/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execjot APL2 V1.0.0 *************************************************
* Called by dottran. Derived function routine to handle outer product. *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLDERIV+APLCB
#include "includes.h"
Aplcb execjot(dp,left,rite)
Aplderiv dp; /* function describing derived function */
Aplcb left,rite; /* arguments */
{
     Errstop; Execfree; Execjota; Execjotc; Execjotd; Pop;
     extern int aplerr;
     void *rfun;
     Aplcb out=NULL;
     int ltype,rtype;

     ltype = left->aplflags & APLMASK;
     rtype = rite->aplflags & APLMASK;
     if ((ltype | rtype) & APLCHAR)
          out = execjotd(left,rite,ltype,rtype,dp->deriv_rite.fun);
     else if (ltype == rtype)
          out = execjota(left,rite,ltype,      dp->deriv_rite.sdp);
     else out = execjotc(left,rite,ltype,rtype,dp->deriv_rite.sdp);
     if (aplerr == 0 && out == NULL)
          return(errstop(78,left,rite,out));
     return(out);
}
