/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* execgetq APL2 V1.0.0 ************************************************
* Called by execgetr to determine if token is for a system variable    *
* other than QUAD_CT or QUAD_IO, and return its value if so.           *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCB+TREE
#include "includes.h"
Aplcb execgetq(tok)
Apltoken tok; /* operand token */
{
	Execqts; Getcb; Quadnami; Treesrch;
	extern int aplerr;
	extern Treelist treehdr;
	Treelist hdr;
	int code,i,*ip;
	char *c;
	Aplcb out;

	code = tok->token_code;
	if (code > QUAD_AI || code < QUAD_ZZ) return(NULL);
	if (NULL != (c = quadnami(code)))
		if (NULL != (out = treesrch(c)))
			return(out); /* value assigned */
	out = NULL;
	switch (code) { /* determine default */
		case QUAD_AV: /* atomic vector */
			out = getcb(NULL,256,APLCHAR + APLTEMP,1,NULL);
			c = out->aplptr.aplchar;
			for (i=0; i<256; i++) *c++ = i;
			break;
		case QUAD_AI: /* account information */
		case QUAD_LX: /* latent expression */
			out = getcb(NULL,0,APLCHAR + APLTEMP,1,NULL); /* null */
			break;
		case QUAD_HT: /* horizontal tab settings */
			out = getcb(NULL,0,APLINT + APLTEMP,1,NULL); /* null */
			break;
		case QUAD_PP:
		case QUAD_PW:
		case QUAD_RL:
		case QUAD_TS:
			out = execqts();
			break;
		case QUAD_TC:
		case QUAD_TT:
		case QUAD_UL:
		case QUAD_WA:
			aplerr = 88; /* not yet implemented */
			break;
	} /* end switch */
	return(out);
}
