/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execexei APL2 V1.0.0 ************************************************
* Called by execexee when the current token is an OPERAND_TOKEN to     *
* check for defined function. operand token ptr, *pfun set to NULL.     *
* Otherwise pfun points to function/operator.  Execexee returns 1 if a *
* niladic user-defined function w/o return is executed during its      *
* processing, or if any other condition, such as aplerr not zero,      *
* that should cause execexed to terminate processing.                  *
***********************************************************************/
#define INCLUDES STDIO+APLTOKEN+APLFUNCI+APLCB+TREE
#include "includes.h"
int execexei(pfun,ptop,tok)
Apltoken pfun[]; /* potential function/operator token ptr */
Apltoken ptop[]; /* operand ptr */
Apltoken tok;    /* current token */
{
     Execnila; Treesrch;
     extern Treelist treehdr;
     extern int aplerr;
     Aplfunc func;

     func = treesrch(tok->token_ptr.token_string);
     if (NULL != func && (func->funcflag & APLFUNC)) {
          tok->token_work = func; /* call later unless niladic */
          if (func->functype & NILAD) { /* niladic */
               *ptop = execnila(tok);
               *pfun = NULL; /* execnila has freed */
               return(NULL != *ptop); /* =0 if niladic w/o return */
          }
     }
     else {
          *ptop = tok; /* operand token */
          *pfun = NULL; /* eliminate duplicate reference */
     }
     return(aplerr == 0); /* ok to continue processing */
}
