/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execdyam APL2 V1.0.0 ************************************************
* The entry point to execdyam is returned by execdyap to execdyas when *
* the function is type SCMD or SCDO. Execdyas stores the entry point to*
* execdyam in argument *pep.                                           *
*      If slashtrc is execdyam's caller, pep will've been set to the   *
* address of dp->deriv_left.func. Later redscan tests for              *
* dp->deriv_left.func equal to either execdyal or execdyam, and if so, *
* and the data type is other than APLAPL, it processes the current     *
* operation as a primitive dyadic scalar.                              *
*      Execdyak may also be the caller.                                *
***********************************************************************/
#define INCLUDES APLCB+FUNSTRUC
#include "includes.h"
Aplcb execdyam(pfun,left,rite)
void *pfun; /* function structure - see funstruc.h */
Aplcb left,rite; /* function arguments */
{
	Dyadicp; Errstop; Execdyat;
	int lefttype,ritetype;

	if (left == NULL || rite == NULL)
		return(errstop(44,left,rite,NULL));
	lefttype = left->aplflags & (APLMASK + APLAPL); /* data type */
	ritetype = rite->aplflags & (APLMASK + APLAPL); /* data type */
	if (lefttype == APLAPL || ritetype == APLAPL)
		return(execdyat(pfun,left,rite,execdyam));
	else return(dyadicp(pfun,left,rite));
}
