/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* encodbl APL2 V1.0.0**************************************************
* Given the correct arguments, encodbl gives the inverse of decodbl.   *
* More generally, encodbl is based on the residue function.            *
* Translates to real floating point.                                   *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb encodbl(left,rite)
Aplcb left,rite;
{
     Encodeb; Errstop; Getcb; Intcopy;
     int datacnt,datatyp,i,*ip,rank;
	Aplcb out;

     if (!matchok(&left,&rite,APLNUMB))
          return(NULL);
     datacnt = left->aplcount * rite->aplcount;
     datatyp = left->aplflags & APLMASK;
     rank = left->aplrank + rite->aplrank;
     out = getcb(NULL,datacnt,datatyp+APLTEMP,rank,NULL);
     if (rank > 1) { /* set dimensions */
          ip=intcopy(out->apldim,left->apldim,left->aplrank,1);
          ip=intcopy(ip,rite->apldim,rite->aplrank,1);
     }
     if (datacnt)
          encodeb(left,rite,out,
                    left->aplptr.apldata,
                    rite->aplptr.apldata,
                    out->aplptr.apldata);
     return(errstop(0,left,rite,out));
}
