/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* eachmonb APL2 V1.0.0 ************************************************
* Called from eachdyaf to process the next set of paired elements.     *
***********************************************************************/
#define INCLUDES APLDERIV+APLCB
#include "includes.h"
Aplcb eachmonb(dp,rite)
Aplderiv dp; /* function describing derived function */
Aplcb rite; /* arguments */
{
     Aplcb out;

     switch (dp->deriv_left.type) {
          case DIX: /* mixed dyadic w/o axis */
               out = dp->deriv_left.func.dix(NULL,rite);
               break;
          case WAX: /* mixed dyadic with axis */
               out = dp->deriv_left.func.wax
                    (NULL,rite,dp->deriv_axis_int);
               break;
          case DBX: /* mixed dyadics with real axis (laminate) */
               out = dp->deriv_left.func.dbx
                    (NULL,rite,dp->deriv_axis_dbl);
               break;
     } /* end switch */
     return(out);
}
