/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* dyadrup APL2 V1.0.0 *************************************************
* Called from dyadrun and outrprdp when the output data type must be   *
* converted from APLNUMB to APLCPLX.                                   *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb dyadrup(out,cnt)
Aplcb out;	/* To be converted from APLNUMB to APLCPLX. */
int cnt;		/* Count of elements finished in out. */
{
	Endoper; Getcb; Intcopy;
	Aplcb hld;
	int tempsave;
	double *ip,*op;

	tempsave = out->aplflags & APLTEMP; /* Out temp? */
	hld = getcb(NULL,out->aplcount,tempsave+APLCPLX,out->aplrank,NULL);
	if (hld == NULL) return(out); /* Error. */
	if (hld->aplrank > 1) /* Copy dimensions? */
		intcopy(hld->apldim, out->apldim, hld->aplrank,1); /* Yes. */
	ip = out->aplptr.apldata;
	op = hld->aplptr.apldata;
	while (cnt--) { /* Copy finished elements. */
		*ip++ = *op++;
		*ip++ = 0e0; /* Imaginary part is zero. */
	}
	if (tempsave) endoper(out); /* Free temporary. */
	return(hld);
}

