/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* dyadicp APL2 V1.0.0 *************************************************
* Called from execdyal, execdyam, to perform dyadic scalar processing, *
* if possible.  Differs from Dyadic in that is uses procedure calls	 *
* instead of functions, allowing a common loop for all data types.	 *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+FUNCODES+FUNSTRUC
#include "includes.h"
Aplcb dyadicp(fun, left, rite)
void *fun;		 /* Describes the scalar dyadic. */
Aplcb left,rite;	 /* Operands. */
{
	Dyadicm; Dyadrun; Dyadset; Errstop; Genint;
	extern int aplerr;
	SCALAR_PROC oper=NULL;
	char *dataout,*leftptr,*riteptr;
	int i,linc,ltype,otype,rinc,rtype;
	Aplcb big,out=NULL;

	for (;;) {
		oper = dyadset(fun, &left, &rite, &otype);
		if (oper == NULL) aplerr = 1;
		if (aplerr) break;
		ltype = left->aplflags & APLMASK;
		rtype = rite->aplflags & APLMASK;
		if ((ltype != rtype) && ((ltype | rtype) & APLCHAR) &&
			(((Codes *)fun)->funky_flags == EQNE)) {
	          	big = (left->aplrank > rite->aplrank) ? left : rite;
				return(errstop(0,left,rite,genint(big,
					((Codes *)fun)->funky_code == NOT_EQUAL)));
		}
		out=dyadicm(left, rite,
			(void **)&dataout, (void **)&leftptr, (void **)&riteptr,
			&linc, &rinc, otype); /* go build APLCB */
          if (aplerr) return(errstop(0,NULL,NULL,out)); /* dyadicm freed */
		out = dyadrun(oper,left,rite,out); /* Go apply scalar. */
     	break; /* final break from for(;;) */
     }
     return(errstop(0,left,rite,out));
}
