/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* disclosg APL2 V1.0.0 ************************************************
* called from disclosf after the output Aplcb has been obtained.		 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb disclosg(rite, axes, ix, rx, dtype)
Aplcb rite;	/* Operand to be "disclosed." */
Aplcb axes;	/* Vector of axis values. */
Aplcb ix;		/* Array of output dimensions, some may not yet be	*/
			/* filled in, indicated by -1 in that position. The	*/
			/* number of items in ix that are -1 should match the  */
			/* rank of rite.								*/
Aplcb rx;		/* Vector of length (RRrite) not initialized. It will	*/
			/* be set by disclosg to the indices of the output	*/
			/* dimensions the the dimensions of rite are mapped to.*/
int dtype;	/* Output data type. */
{
	Disclosh; Endoper; Errinit; Errstop; Getcb; Intcopy; Multset;
	extern int aplerr;
	extern int indxorg;
	int cnt, i, *ip, j, *jp, k, *kp;
	Aplcb out=NULL;

	for(;;) { /* lets me use break for errors */
		if (errinit()) break;
		if (ix->aplcount) {
			cnt = 1;
			ip=ix->aplptr.aplint;
			jp = rite->apldim;
			kp = rx->aplptr.aplint;
			for (i=0; i < ix->aplcount; i++) {
				if (*ip == -1)	{	/* Is output dim. filled in? */
					*ip = *jp++;	/* If not, fill in rite's */
								/* dimensions. */
					*kp++ = i + indxorg;
				}
				cnt *= *ip++; /* Count of output items. */
			}
		}
		else cnt = 0;
		if (out = getcb(NULL,cnt,APLTEMP+dtype,i=ix->aplcount,NULL))
			ip = intcopy(out->apldim,ix->aplptr.aplint,i,1);
		jp = out->apldim; /* output dimensions array */
		ip = ix->aplptr.aplint;
		i = ix->aplcount;
		while(i--) *(ip + i)  = indxorg - 1; /* init. out indices */
		disclosh(
			rite->aplrank,		 /* riterank	- Rank of input.		*/
			rite->apldim,		 /* ritedim	- Dimensions of input.	*/
			rite->aplptr.aplapl, /* cb		- Input aplcb array.	*/
			out->aplrank,		 /* outrank	- Rank of output.		*/
			out->aplflags & (APLMASK+APLAPL), /* otype - Output datatype.*/
			out->aplcount,		 /* r		- Number of output elements.*/
			out->aplptr.aplchar, /* op		- Output array.		*/
			axes->aplcount,	 /* axescnt	- Dimensions in subelement.*/
			axes->aplptr.aplint, /* mp		- Axes mapping array.	*/
			rx->aplptr.aplint,	 /* rp		- Axes mapping array.	*/
			ip,				 /* ip		- Indices array, initialized */ 
							 /* 			  indxorg-1.			*/
			jp);				 /* jp		- Output dimensions array.*/
		break;
	}
	endoper(rx);
	return(errstop(0,axes,ix,out));
}
