/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* depthsub APL2 V1.0.0 ************************************************
* Called by depth.                                                     *
* Reports levels of nesting, 0 for simple scalars.  For other arrays,  *
* 1 plus the depth of the item with the maximum depth.  Returns int.   *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int depthsub(rite)
Aplcb rite;
{
     Depth; Depthsub; Enclose; Endoper; First; Imax; Ivalue;
     Aplcb *ritp,rcb;
     int i,idepth,typ;

     typ = rite->aplflags & (APLMASK + APLAPL);
     if (typ != APLAPL)
          if (rite->aplrank)
               idepth = 1; /* input is simple non-scalar */
          else idepth = 0; /* input is simple scalar */
     else if (rite->aplcount) { /* non-empty nested array */
          idepth = 0;
          ritp = rite->aplptr.aplapl; /* aplcb array */
          for (i = rite->aplcount; i; i--)
               idepth = imax( idepth, depthsub(*ritp++) );
          idepth++; /* 1 plus greatest contained depth */
     }
     else {
		idepth = ivalue(depth(enclose(first(rite),NULL)));
		rite = NULL; /* Don't free twice. */
	}
	endoper(rite);
     return(idepth);
}
