/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* complex APL2 V1.0.0 *************************************************
* Called by execjotc.                                                  *
* Returns a copy of the APL variable received, converted to complex    *
* form.                                                                *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb complex(rite)
Aplcb rite;
{
	Aplcopy; Errinit; Errstop; Getcb; Intcopy; Real;
	int i,*ip;
	double *fin,*fout;
     Aplcb out=NULL;

	if (errinit())
		return(errstop(0,NULL,rite,NULL));
     switch (rite->aplflags & (APLMASK | APLAPL)) {
          case APLCPLX:
          	out = aplcopy(rite);
          	return(errstop(0,NULL,rite,out));
          case APLINT:
          	rite = real(rite);
          case APLNUMB:
          	break;
          default:
			if (rite->aplcount)
				return(errstop(18,NULL,rite,NULL)); /* can't do */
               break;
     } /* end switch */
	out=getcb(NULL,rite->aplcount,APLTEMP+APLCPLX,rite->aplrank,NULL);
	if (rite->aplrank > 1)
		ip = intcopy(out->apldim,rite->apldim,rite->aplrank,1);
	if (out->aplcount) {
		fin = rite->aplptr.apldata;
		fout = out->aplptr.apldata;
		for (i=out->aplcount; i>0; i--) {
			*fout++ = *fin++;
               *fout++ = 0e0;
		}
	}
	return(errstop(0,NULL,rite,out));
}
