/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplwrite APL2 V1.0.0 ************************************************
* Called from aplwksp to do )WRITE.                                    *
***********************************************************************/
#define INCLUDES APLCB+APLMEM+STDIO+TREE
#include "includes.h"
void aplwrite(rite,cp,cpend)
Aplcb rite; /* aplcb for command text */
char *cp; /* Pointer to char immediately after right parenthesis */
char *cpend; /* Pointer to end of command text */
{
	Aplfopn; Treenode;
	extern int aplerr;
	FILE *fp;
	Avlnode p;
	Aplcb wrk;
	int cols,rows;
	char *ep,*ip,*wp;

	if (NULL == (p = treenode("file")) || NULL == (wrk = p->avlleaf) ||
		!(wrk->aplflags & APLCHAR) || wrk->aplrank != 2) {
		aplerr = 122; /* No file variable. */
		return;
	}
	if (NULL == (fp = aplfopn(cp,cpend,"w")))
		return; /* Couldn't open output file. */
	rows = *(wrk->apldim);
	cols = *(wrk->apldim + 1);
	ip = wrk->aplptr.aplchar;
	while (rows--) {
		for (ep = ip + cols - 1; ep > ip && *ep == ' '; ep--)
			;
		for (wp = ip; wp <= ep; wp++)
			fputc(*wp, fp); /* Write current line. */
		fputc('\n', fp); /* Carriage return indicates end of line. */
		ip += cols;
	}
	fclose(fp);
#if APL_DOS
	errno = 0; /* Clear any error for close. */
#endif
}
