/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* apltypf APL2 V1.0.0 *************************************************
* Called by apltype.  Copies 0s to numeric types and blanks to         *
* character types.  Recursively calls itself for type APLAPL.          *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void *apltypf(to,datacnt,datatyp)
void *to;    /* place to copy to        */
int datacnt; /* number of items to copy */
int datatyp; /* type of data to copy    */
{
     Apltypf; Chrcopy; Dblcopy; Intcopy;
     Aplcb *tocb,top;
     void *d;
     const int    incr=0;
     const double dblzero=0.0;
     const int    intzero=0;
     const char   chrzero=' ';

     if (0 == datacnt) return(to); /* nothing to do */
     switch (datatyp) {
          case APLCPLX:
               d = dblcopy(to,(void *)&dblzero,datacnt * 2,incr);
               break;
          case APLNUMB:
               d = dblcopy(to,(void *)&dblzero,datacnt,incr);
               break;
          case APLINT:
               d = intcopy(to,(void *)&intzero,datacnt,incr);
               break;
          case APLCHAR:
               d = chrcopy(to,(void *)&chrzero,datacnt,incr);
               break;
          case APLAPL:
               tocb = (struct aplcb **)to;
               while(datacnt--) {
                    top = *tocb++;
                    if (top->aplcount)
	                    apltypf(top->aplptr.aplchar, top->aplcount,
     	                    top->aplflags & (APLMASK + APLAPL));
               }
               d = tocb;
     } /* end switch */
     return(d);
}
