/* Copyright (C) 1993, 1998 by Thomas Glen Smith.  All Rights Reserved. */
/* aplmsg APL2 V1.0.1 **************************************************
* Called by funcsusp.  Given an APL error message number, aplmsg will  *
* return a pointer to the error message.                               *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
char *aplmsg(no)
int no;
{
     switch (no) {
          case 1: return(
"1 - non empty variables of dissimilar type are invalid to dyadic.");
          case 2: return(
"2 - arguments to catenate aren't conformable.");
          case 3: return(
"3 - invalid axis.");
          case 4: return(
"4 - invalid left argument to compress/expand derived function.");
          case 5: return(
"5 - arguments to mdivide must have ranks <= 2.");
          case 6: return(
"6 - # rows m/b >= # columns in right argument to mdivide and matinv.");
          case 7: return(
"7 - row dimension must match in the two arguments to mdivide.");
          case 8: return(
"8 - right argument to mdivide or matinv isn't invertible.");
          case 9: return(
"9 - invalid axis value");
          case 10: return(
"10 - left argument to reshape must be of rank 0 or 1.");
          case 11: return(
"11 - can't reshape something from nothing.");
          case 12: return(
"12 - invalid constant.");
          case 13: return(
"13 - an empty vector and undefined identity in reduce.");
          case 14: return(
"14 - the arguments to format must be numeric.");
          case 15: return(
"15 - the left argument to take or drop can't have rank > 1.");
          case 16: return(
"16 - in take or drop, the left's count must equal right's rank.");
          case 17: return(
"17 - dyadic function arguments are not conformable.");
          case 18: return(
"18 - character-to-real conversion isn't supported.");
          case 19: return(
"19 - character-to-integer conversion isn't supported.");
          case 20: return(
"20 - an arithmetic (+-/) or math (sin, cos) function failed.");
          case 21: return(
"21 - conversion from numeric to character is not supported.");
          case 22: return(
"22 - ivalue has been passed an empty variable.");
          case 23: return(
"23 - value has been passed an empty variable.");
          case 24: return(
"24 - Dimensions must conform in inner product and decode.");
          case 25: return(
"25 - the left argument to dyadic format has the wrong rank.");
          case 26: return(
"26 - the left argument to format has incorrect length.");
          case 27: return(
"27 - out of main storage.");
          case 28: return(
"28 - a width is too large in format.");
          case 29: return(
"29 - a width is too small in format.");
          case 30: return(
"30 - no match, count of nonzero left items and right's axis in expand.");
          case 31: return(
"31 - no match, left count and right's axis in expand.");
          case 32: return(
"32 - no match, left count and right's rank in transpose.");
          case 33: return(
"33 - left is missing a positive integer from 0 to n in transpose.");
          case 34: return(
"34 - index out of range.");
          case 35: return(
"35 - bad number of replacements in indexv.");
          case 36: return(
"36 - invalid argument to factorial.");
          case 37: return(
"37 - argument to iroll is less than 0.");
          case 38: return(
"38 - integer division by 0.");
          case 39: return(
"39 - real division by 0.");
          case 40: return(
"40 - unsupported values to binom function.");
          case 41: return(
"41 - arguments to deal must be 1 item long.");
          case 42: return(
"42 - arguments to deal must be positive integers.");
          case 43: return(
"43 - left must be <= right in deal.");
          case 44: return(
"44 - null argument to quadout or execdyam.");
          case 45: return(
"45 - argument to indexgen must be a positive integer.");
          case 46: return(
"46 - Error.");
          case 47: return(
"47 - argument to grade can't be character");
          case 48: return(
"48 - right argument to rotate has bad shape.");
          case 49: return(
"49 - shapes of left and right excluding axis must match in rotate.");
          case 50: return(
"50 - shapes of left and right must match in laminate.");
          case 51: return(
"51 - axis must be positive in laminate.");
          case 52: return(
"52 - axis too large in laminate.");
          case 53: return(
"53 - wrong number of indices to indexm");
          case 54: return(
"54 - index out of range in indexm.");
          case 55: return(
"55 - error in assign.");
          case 56: return(
"56 - argument to execute has rank greater than one.");
          case 57: return(
"57 - argument to execute must be character.");
          case 58: return(
"58 - syntax error.");
          case 59: return(
"59 - argument not found where expected during execute.");
          case 60: return(
"60 - missing result during execute.");
          case 61: return(
"61 - stack not empty at end of expression in execute.");
          case 62: return(
"62 - invalid result from execute.");
          case 63: return(
"63 - missing operator/function during execute processing.");
          case 64: return(
"64 - unexpected bracketed value.");
          case 65: return(
"65 - unknown function found during dyadic execute processing.");
          case 66: return(
"66 - left argument to assignment must be a variable name.");
          case 67: return(
"67 - missing monadic argument during execute processing.");
          case 68: return(
"68 - scalar can't be indexed.");
          case 69: return(
"69 - unknown argument type during execute.");
          case 70: return(
"70 - missing right argument during execute.");
          case 71: return(
"71 - null argument during monadic processing in module execmonb.");
          case 72: return(
"72 - invalid scalar function used with reduce or scan.");
          case 73: return(
"73 - unknown monadic function.");
          case 74: return(
"74 - unexpected function operand to dot product.");
          case 75: return(
"75 - only equal/not equal can be applied to character data.");
          case 76: return(
"76 - Scan does not accept a left argument.");
          case 77: return(
"77 - Apl null (jot) must be succeeded by a period.");
          case 78: return(
"78 - null output from dot product.");
          case 79: return(
"79 - missing scalar function to the left of reduce/scan operator.");
          case 80: return(
"80 - left bracket not found when expected in execute.");
          case 81: return(
"81 - semicolon not found when expected in execute.");
          case 82: return(
"82 - token expected to the left of left bracket.");
          case 83: return(
"83 - axis must be a one-element vector or scalar.");
          case 84: return(
"84 - artanh argument > 1.");
          case 85: return(
"85 - left value to circular function must be integer -12 thru 12.");
          case 86: return(
"86 - denominator of exponent must be odd if left negative to power.");
          case 87: return(
"87 - exponent must approximate rational number if left negative to power.");
          case 88: return(
"88 - system variable not yet implemented.");
          case 89: return(
"89 - axis indicated where it's not accepted.");
          case 90: return(
"90 - input to quad fx m/b character matrix, or nested vector.");
          case 91: return(
"91 - can't assign to a label.");
          case 92: return(
"92 - variable size is too big for this implementation.");
          case 93: return(
"93 - invalid syntax in function header.");
          case 94: return(
"94 - user function without result must stand alone.");
          case 95: return(
"95 - invalid syntax = right arrow then cap_null in function.");
          case 96: return(
"96 - a local name can't be repeated in a function header.");
          case 97: return(
"97 - local variable names and labels can't be synonyms in a function.");
          case 98: return(
"98 - no returned value from user function when exected.");
          case 99: return(
"99 - unknown command.");
          case 100: return(
"100 - file doesn't exist.");
          case 101: return(
"101 - file can't be created.");
          case 102: return(
"102 - file can't be opened.");
          case 103: return(
"103 - file can't be written to.");
          case 104: return(
"104 - file can't be closed.");
          case 105: return(
"105 - file can't be read from.");
          case 106: return(
"106 - workspace version not supported.");
          case 107: return(
"107 - )save specifies an existing workspace which is not the current.");
          case 108: return(
"108 - )save where?.");
          case 109: return(
"109 - input to quadcr m/b a non-empty character vector.");
          case 110: return(
"110 - input to quadcx or quadnc m/b character vector or matrix.");
          case 111: return(
"111 - left argument to quadnl m/b character vector.");
          case 112: return(
"112 - bad number of replacement values in indexm.");
          case 113: return(
"113 - left argument to reshape must be zero or positive.");
          case 114: return(
"114 - del editor expected a function name.");
          case 115: return(
"115 - del editor found function name already in use.");
          case 116: return(
"116 - del editor didn't find named function to edit.");
          case 117: return(
"117 - quad nl accepts only values 1, 2, and 3 in the right argument.");
          case 118: return(
"118 - not grouped, name in use..");
          case 119: return(
"119 - group name is undefined.");
          case 120: return(
"120 - no function is currently suspended to branch in.");
          case 121: return(
"121 - left argument to replicate may contain only positive values.");
          case 122: return(
"122 - Ranks differ in disclose.");
          case 123: return(
"123 - Invalid axes.");
          case 124: return(
"124 - Arguments inconsistent in pick.");
          case 125: return(
"125 - Nested variable is argument to integer().");
		case 126: return(
"126 - bad left argument to n-wise.");
		case 127: return(
"127 - item out of place.");
		case 128: return(
"128 - length error.");
		case 129: return(
"129 - rank error.");
		case 130: return(
"130 - argument of complex gamma function too close to a pole.");
		case 131: return(
"131 - Invalid data type for format by example.");
		case 132: return(
"132 - Invalid model for format by example.");
		case 133: return(
"133 - Domain error.");
		case 134: return(
"134 - Items of right to form m/b simple numeric scalar or character vector.");
		case 135: return(
"135 - Partition needs left to be simple vector of nonnegative integers.");
		case 136: return(
"136 - Real argument to acosh must not be less than 1.");
          case 995: return(
"995 - Matrix divide of complex numbers not yet supported.");
          case 996: return(
"996 - Non-integer powers of complex numbers not yet supported.");
          case 997: return(
"997 - clearing state indicator to last suspended function.");
          case 998: return(
"998 - end of apl processing.");
          default: return(
"999 - internal error");
     }
}
