/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplloae APL2 V1.0.0 *************************************************
* Called from aplload and aplcpy to load a workspace file into memory. *
***********************************************************************/
#define INCLUDES APLCB+APLMEM+IO+STDIO+STAT
#include "includes.h"
int aplloae(wrk,cp,cpend)
char *wrk;	/* Pointer to entire command text. */
char *cp;		/* Pointer to char after command verb. */
char *cpend;	/* Pointer to end of command text. */
{
	Aplclear; Aplmsg; Aplparfn; Endoper; Execmsg;
	extern int aplerr;
	extern char *aplfile;
#if ! APL_DOS
        extern int errno;
#endif 
	struct stat buf;
	char *newfile,*s;
	int fp,i,ret=0;

	newfile = aplparfn(cp,cpend);
	if (newfile == NULL) {
		if (aplfile == NULL) {
			i = strlen(wrk);
			execmsg(wrk, i, i, "load from where?");
			return(ret); /* unable to load */
		}
		newfile = aplfile; /* default file to )LOAD from */
	}
	if (stat(newfile,&buf)) { 
		fp = -1; /* indicate no file */
		i = 100; /* File doesn't exist. */
	}
	else {
		fp = open(newfile, S_IREAD);
		i = 102; /* File can't be opened. */
	}
	errno = 0;
	if (fp != -1) {
		aplclear(); /* clear workspace */
		i = aplloaf(fp); /* go read file. */
		fp = close(fp); /* close file */
		if (fp == -1 && i == 0) i = 104; /* unable to close */
		if (i) fp = -1; /* indicate error */
	}
	if (fp == -1) {
		aplerr = i; /* File doesn't exist or can't be opened. */
		execmsg(newfile,strlen(newfile),0,aplmsg(aplerr));
		if (aplfile != newfile) free (newfile);
	}
	else {
		if (aplfile != NULL && aplfile != newfile) free(aplfile);
		aplfile = newfile;
		ret = 1; /* successfully loaded */
	}
	return(ret);
}
