/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* aplgrour APL2 V1.0.0 ************************************************
* Called from aplgroup and aplgrouq to add a name to the new list.     *
***********************************************************************/
#define INCLUDES APLTOKEN
#include "includes.h"
void aplgrour(pgrphdr,prows,pcols,namebuf,namelen)
Apltoken pgrphdr[];           /* fifo stack of new names */
int *prows;                   /* ptr to new row count */
int *pcols;                   /* ptr to new col count */
char *namebuf;                /* name buffer */
int namelen;                  /* length of name buffer */
{
     Chrcopy; Execfree; Imax; Isign; Newtok;
     extern int aplerr;
     Apltoken cur,new,old;
     char *cp;
     int i;

     new = newtok(OPERAND_TOKEN, 0, 0, namebuf, namelen);
     if (aplerr) return;
     old = NULL;
     for (cur = *pgrphdr; cur != NULL;
          cur = cur->token_queue.token_next_ptr) {
          i = isign(strcmp(cur->token_ptr.token_string,
               new->token_ptr.token_string));
          if (i == 0) { /* name already in list */
               execfree(new);
               return;
          }
          if (i > 0)
               break; /* found position */
          old = cur;
     }
     if (old == NULL) { /* new goes 1st in queue */
          new->token_queue.token_next_ptr = *pgrphdr;
          *pgrphdr = new;
     }
     else { /* new not 1st in queue */
          new->token_queue.token_next_ptr =
               old->token_queue.token_next_ptr;
          old->token_queue.token_next_ptr = new;
     }
     (*prows)++;
     *pcols = imax(*pcols,namelen);
}
