/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplfopn APL2 V1.0.0 *************************************************
* Called from aplrun, aplread and aplwrite to parse a file name and    *
* open it.                                                             *
***********************************************************************/
#define INCLUDES STDIO+APLCHDEF
#include "includes.h"
void *aplfopn(cp,cpend,mode)
char *cp;		/* Pointer to char after right parenthesis.	*/
char *cpend;	/* Pointer to end of command text.			*/
char *mode;	/* File mode, e.g. "r", "w", etc.			*/
{
	Aplscan;
	extern int aplerr;
	FILE *fp;
	int code;
	char *s;

	if (cp == cpend)
		aplerr = 58; /* syntax error - no file name supplied */
	else {
		s = cp; /* save possible pointer to first non-blank */	
		if (SPACE != (code = aplscan(&s,cpend)))
			s = cp; /* s == 1st nonblank */
		else if (s == cpend)
			aplerr = 58; /* syntax error - no file name */
	}
	if (aplerr) return(NULL);
	if (NULL != (fp = fopen(s,mode)))
		return(fp); /* File successfully opened. */
	errinit(); /* Clear error indicators. */
	aplerr = 102; /* can't open file */
	return(NULL);
}
