/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledme APL2 V1.0.0 *************************************************
* Called from apledmd after the statement to be modified has been      *
* formatted and displayed.                                             *
***********************************************************************/
#define MAXLINE 1024
#define INCLUDES APLCB+APLCHDEF+APLED+APLTOKEN+STDIO+STRING
#include "includes.h"
void apledme(e,line,off)
struct apledst *e;		/* Edit common area.					*/
char line[];			/* Formatted statement.					*/
int off;				/* offset to place cursor				*/
{
	Apledmf; Codechar; Edline; Execmsg; Imin;
	extern int aplerr;
	int c,code_a,code_z,code_0,code_9,i,j,k,limit,m,n,p,stmtlen;
	char edit[MAXLINE];

	stmtlen = strlen(line);
	execmsg(line,stmtlen,0,NULL); /* display statement text */
	off = (off == 0) ? stmtlen : imin(off+10,stmtlen);
	edit[j = stmtlen] = '\0';
	while ( j-- )
		edit[j] = ' ';
	k = edline(edit,off,MAXLINE,0); /* get edit mask */
	if (k < 0) return; /* don't bother with EOF */
	code_a = *codechar(APL_A);
	code_z = *codechar(APL_Z);
	code_0 = *codechar(APL_0);
	code_9 = *codechar(APL_9);
	n = 0; /* final position of cursor */
	while (k--) {
		c = edit[k]; /* current edit character */
		if (c == '/') { /* it is delete */
			strcpy(line+k,line+k+1); /* shift left */
			stmtlen--; /* reduce length of line by 1 */
			if (n) n--; /* reduce cursor position */
		}
		else { /* check for insert */
			if (c >= code_0 && c <= code_9) /* digit */
				j = c - code_0;
			else if (c >= code_a && c <= code_z) /* digit */
				j = (c - code_a + 1) * 5;
			else j = 0; /* ignore all others */
			if (j) {
				n = k; /* save insertion position */
				while(j-- && stmtlen < (MAXLINE - 1)) {
					for ( m = stmtlen++; m > n; m--)
						line[m] = line[m-1];
					line[n] = ' '; /* insert space */
				}
			}
		}
	}
	apledmf(e,line,n,0); /* more edit function */
}
