/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplediw APL2 V1.0.0 *************************************************
* Called from aplediu to prepare an existing function definition for   *
* DEL editing.                                                         *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLMEM+APLTOKEN
#include "includes.h"
Apled aplediw(e,fun)
Apledst e;	/* Edit common area.					*/
Aplfunc fun;	/* aplfunc function definition structure. 	*/
{
	Apledcm; Apledix;
	extern int aplerr;
	Apltoken labels,tokhdr;
	Apled olded,newed=NULL,edhdr=NULL;
	int istmtno,stmtlen,tokcnt;

	labels = fun->funclabs;
	for (istmtno = 0; istmtno < fun->funcstmt; istmtno++) {
		tokhdr = *(fun->functokp + istmtno);
		tokcnt = *(fun->functokc + istmtno);
		if (labels != NULL && labels->token_offset == istmtno) {
			tokcnt += 2;
			labels = labels->token_queue.token_next_ptr;
		}
		newed = apledix(e,newed,tokhdr,tokcnt,(double) istmtno,0);
		if (newed == NULL)
			break; /* out of memory - aplerr already set */
		if (tokhdr->token_code == CAP_NULL) {
			stmtlen = *(fun->functext->apldim + 1);
			apledcm(newed, /* capture comment text */
				fun->functext->aplptr.aplchar + istmtno * stmtlen,
				stmtlen);
		}
	}
}
