/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledfx APL2 V1.0.0 *************************************************
* Called from apledit to fix a function after editing is complete.     *
***********************************************************************/
#define MAXLINE 1024
#define INCLUDES APLCB+APLED+APLFUNCI+APLMEM+APLTOKEN+STRING
#include "includes.h"
void apledfx(e)
Apledst e;			/* Edit common area.				*/
{
	Apledps; Chrcopy; Execqfx; Getcb; Imax;
	extern int aplerr;
	Aplcb out;
	Apled ed;
	int cols,i,j,k,rows;
	char line[MAXLINE],*op;

	cols = 0; /* Will hold maximum statement length */
	rows = 0; /* Will hold number of statements */
	for (ed = e->edhdr; ed != NULL; ed = ed->aplednxt) {
		if (ed->apledch == NULL) {
			line[0] = '\0'; /* empty line */
			apledps(ed,line); /* get formatted statement */
			i = strlen(line) + 1;
			ed->apledch = malloc(i);
			if (aplerr) break; /* probably out of storage */
			strcpy(ed->apledch,line); /* copy statement text */
		}
		cols = imax(cols,strlen(ed->apledch));
		rows++;
	}
	if (rows == 0) return; /* nothing to fix */
	out = getcb(NULL,rows*cols,APLCHAR+APLTEMP,2,NULL);
	if (aplerr) return;
	*(out->apldim) = rows;
	*(out->apldim + 1) = cols;
	op = out->aplptr.aplchar;
	for (ed = e->edhdr; ed != NULL; ed = ed->aplednxt) {
		i = strlen(ed->apledch);
		op = chrcopy(op, ed->apledch, i, 1); /* copy, update op */
		if (0 < (j = cols - i))
			op = chrcopy(op, " ", j, 0); /* pad w/blanks */
	}
	endoper(execqfx(out)); /* go fix this function */
}
