/*_ io.h   Sat Aug 19 1989   Modified by: Walter Bright */
/* Copied from /dosd/my/lang/zortech/include/io.h */
/* Copyright (C) 1987-1990 by Walter Bright	*/
/* All Rights Reserved				*/
/* Written by Walter Bright			*/

/* Declarations for low level I/O functions	*/

#ifndef __IO_H
#define __IO_H	1

#if __cplusplus
extern "C" {
#endif

#ifdef __STDC__
#define __CDECL
#define __STDCALL
#else
#define __CDECL _cdecl
#define __STDCALL _stdcall
#endif

#if __OS2__ && __I86__ >= 3
#define __CLIB	__STDCALL
#else
#define __CLIB	__CDECL
#endif

int __CLIB read(int,void *,unsigned);
int __CLIB write(int,const void *,unsigned);

#if __I86__ <= 2
int __CLIB _readx(int,void *,unsigned,unsigned);
int __CLIB _writex(int,void *,unsigned,unsigned);
#endif

#if M_UNIX || M_XENIX
char __CLIB *ttyname(int filedes);
int __CLIB rdchk(int filedes);
int __CLIB fcntl(int filedes, int cmd, int arg);
int __CDECL ioctl(int filedes, int cmd,...);
#else
int __CDECL dos_open(const char *,int,...);
int __CDECL sopen(const char *, int, int, ...);
int __CLIB setmode(int,int);
#endif

int __CDECL open(const char *,int,...);
int __CLIB creat(const char *,int);
int __CLIB close(int);
int __CLIB locking(int, int, long);
int __CLIB unlink(const char *);
int __CLIB remove(const char *);
int __CLIB chsize(int, long);
int __CLIB chmod(const char *,int);
int __CLIB dup(int);
int __CLIB dup2(int, int);
char * __CLIB mktemp(char *);

int __CLIB access(const char *,int);
#define F_OK	0	/* does file exist?	*/
#define X_OK	1	/* execute permission?	*/
#define W_OK	2	/* write permission?	*/
#define R_OK	4	/* read permission?	*/

long __CLIB lseek(int,long,int);
#define SEEK_SET	0	/* seek from start of file	*/
#define SEEK_CUR	1	/* relative to current position */
#define SEEK_END	2	/* relative to end of file	*/

long __CLIB filesize(const char *);
long __CLIB filelength(int);
int __CLIB isatty(int);

unsigned short __CLIB getDS(void);

#ifndef __STDC__
#define getDS() ((unsigned short)asm(0x8C,0xD8))
#endif

#if __cplusplus
}
#endif

#endif /* __IO_H */
