/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* funstruc.h - APL2 V1.0.0 ********************************************
* Funstruc.h and funstrud.h define all the structures used to describe *
* builtin APL functions and operators.                                 *
***********************************************************************/
#if !defined(FUNSTRUC_INCL)
#define FUNSTRUC_INCL
#if !defined(SCALAR_PROC_DEF)
#define SCALAR_PROC_DEF   
typedef void (*SCALAR_PROC)(); /* Entry to dyadic scalar proc. */
#endif
#include "funstrud.h"
typedef struct oper { /* slash, slope, each, dot, etc. */
     Codes codes;
     int (*eptok)(Apltoken); /* transformer to derived function */
} Oper;
typedef struct dmxo { /* dyadic mixed only, or dual purpose */
     Codes codes;
     Mixed_dyadics dyad;
} Dmxo;
typedef struct mixa { /* mixed functions */
     Codes codes;
     Mixed_monadics mona;
     Mixed_dyadics  dyad;
} Mixa;
typedef struct msmd {/*monadic scalar mixed dyadic roll/deal not/without*/
     Codes codes;
     Scalar_monadics mona;
     Mixed_dyadics   dyad;
} Msmd;
typedef struct rela { /* relational functions */
     Codes codes;
     Scalar_dyadics dyad;
} Rela;
typedef struct eqne { /* equality functions */
     Rela rel;
     int    (*ch)(char, char);
     void   (*ph)(char*, char*, int*);
     void   (*pd)(char*, char*, double*);
     void   (*eqnedum)(void*, void*, int*);
} Eqne;
typedef struct scalars {
     Codes codes;
     Scalar_dyadics  dyad;
     Scalar_monadics mona;
} Scalars;
#endif
