/* Copyright (C) 1993, 1998 by Thomas Glen Smith.  All Rights Reserved. */
#if !defined(ENTRYS_INCL)
#define ENTRYS_INCL
/* entrys.h - APL2 V1.0.1 **********************************************
* Entry declarations for all CAPLIB2 routines.                         *
***********************************************************************/
#if !defined(SCALAR_PROC_DEF)
#define SCALAR_PROC_DEF
typedef void (*SCALAR_PROC)();/* Entry to dyadic scalar proc. */
#endif
#define Acosh double acosh(double)
#define Acoshx void acoshx(double *, double *)
#define Acosx void acosx(double *, double *)
#define Allcopy void *allcopy(void*, void*, int, int, int, int)
#define And int and(double, double)
#define Andp void andp(double *, double *, int *)
#define Aplcbpr Aplcb aplcbpr(char *, Aplcb)
#define Aplclean void aplclean(void)
#define Aplclear void aplclear(void)
#define Aplclsub void aplclsub(Avlnode)
#define Aplcomex Aplcb aplcomex(Aplderiv, Aplcb, Aplcb)
#define Aplcopy Aplcb aplcopy(Aplcb)
#define Aplcpy void aplcpy(Aplcb, char *, char *, int)
#define Aplcpya void aplcpya(Treelist , char *, int)
#define Aplcpyb void aplcpyb(Treelist , Avlnode , int)
#define Aplcpyc void aplcpyc(Treelist , char *, void *, int)
#define Aplcpyd void aplcpyd(Treelist , Aplcb, int)
#define Aplcpywr void aplcpywr(void)
#define Apldrop void apldrop(Aplcb, char *, char *)
#define Apledcl void apledcl(Apledst)
#define Apledcm void apledcm(Apled, char *, int)
#define Apleddl void apleddl(Apledst, char *, int, int)
#define Apledfm char *apledfm(double)
#define Apledfr void apledfr(Apledst)
#define Apledfx void apledfx(Apledst)
#define Apledit Aplcb apledit(Aplcb, char *, char *)
#define Aplediu void aplediu(Apledst, char *, int)
#define Aplediv void aplediv(Apledst)
#define Aplediw Apled aplediw(Apledst, Aplfunc)
#define Apledix Apled apledix(Apledst, Apled,\
          Apltoken, int, double, int)
#define Aplediy void aplediy(Apledst, char *, int, char *, int)
#define Aplediz void aplediz(Apledst)
#define Apledmd void apledmd(Apledst, char *, int, char *, int)
#define Apledme void apledme(Apledst, char *, int)
#define Apledmf void apledmf(Apledst, char *, int, int)
#define Aplednn double aplednn(Apledst)
#define Apledno double apledno(struct apltoken *, char *, int)
#define Aplednw void aplednw(Apledst, double, char *, int,\
          char *, int)
#define Apledpf void apledpf(double, char *, int)
#define Apledpq void apledpq(int, char *)
#define Apledpr char *apledpr(Apled, int)
#define Apledps void apledps(Apled, char *)
#define Apledqu void apledqu(Apledst, char *, int, int)
#define Apledrc void apledrc(Apledst, char *)
#define Aplerase void aplerase(Aplcb, char *, char *)
#define Aplfile FILE *aplfile(char *, char *, char *)
#define Aplfill void *aplfill(Aplcb)
#define Aplfopn void *aplfopn(char *, char *, char *)
#define Aplfree void aplfree(void *)
#define Aplgetc int aplgetc(void)
#define Aplgetch int aplgetch(void)
#define Aplgroup void aplgroup(Aplcb, char *, char *)
#define Aplgrouq void aplgrouq(Apltoken *, int *, int *, Aplcb)
#define Aplgrour void aplgrour(Apltoken *, int *, int *, char *, int)
#define Aplgrous void aplgrous(Apltoken *, int,  int, char *)
#define Aplgrp void aplgrp(Aplcb, char *, char *)
#define Aplgrps void aplgrps(Aplcb, char *, char *, int)
#define Aplgrpsb void aplgrpsb(char *, int, Avlnode)
#define Aplinit void aplinit(void)
#define Apllib void apllib(Aplcb, char *, char *)
#define Aplload void aplload(char *, char *, char *)
#define Aplloae int aplloae(char *, char *, char *)
#define Aplloaf int aplloaf(int)
#define Apllov1 int apllov1(int)
#define Aplmall void *aplmall(int)
#define Aplmatch int aplmatch(Aplcb, Aplcb)
#define Aplmatci int aplmatci(Apluptr, Apluptr, int, int)
#define Aplmatcj int aplmatcj(Apluptr, int, double *)
#define Aplmatck int aplmatck(Apluptr, Apluptr, int, int)
#define Aplmsg char *aplmsg(int)
#define Aplname char *aplname(char *, char *)
#define Aplnamsb char *aplnamsb(char *, char *)
#define Aplnest Aplcb aplnest(Aplcb)
#define Aplnewl void aplnewl(void)
#define Aplparfn char *aplparfn(char *, char *)
#define Aplparse Apltoken aplparse(char *, int)
#define Aplparsf void aplparsf(Apltoken, char**, char*, char*, int*, int*)
#define Aplparsg int aplparsg(int)
#define Aplpnam void aplpnam(Apltoken, char *, char **, char *)
#define Aplpnum void aplpnum(Apltoken, char **, char *)
#define Aplprint void aplprint(char *)
#define Aplputch void aplputch(char)
#define Aplquad void aplquad(Apltoken, char **, char *)
#define Aplquae int aplquae(char **, char *)
#define Aplquote void aplquote(Apltoken, char **, char *)
#define Aplread void aplread(Aplcb, char *, char *)
#define Aplreae void aplreae(struct lines *, int, int)
#define Aplrun void aplrun(Aplcb, char *, char *)
#define Aplsave void aplsave(Aplcb, char *, char *)
#define Aplsavf int aplsavf(int)
#define Aplscan int aplscan(char **, char *)
#define Aplsi void aplsi(Aplcb, char *, char *, int)
#define Aplsrand void aplsrand(Aplcb)
#define Aplstr char *aplstr(char *, char *, int)
#define Apltype Aplcb apltype(Aplcb)
#define Apltypf void *apltypf(void *, int, int)
#define Aplwksp int aplwksp(Aplcb, char *, char *)
#define Aplwksq int aplwksq(int *, char **, char *)
#define Aplwksr Aplcb aplwksr(Aplcb, char *, char *, int)
#define Aplwkst int aplwkst(void)
#define Aplwrite void aplwrite(Aplcb, char *, char *)
#define Aplwsid void aplwsid(Aplcb, char *, char *)
#define Asinh double asinh(double)
#define Asinhx void asinhx(double *, double *)
#define Asinx void asinx(double *, double *)
#define Assign Aplcb assign(char *, Aplcb)
#define Atanh double atanh(double)
#define Atanhx void atanhx(double *, double *)
#define Atanx void atanx(double *, double *)
#define Avladd Avlnode avladd(Avlnode *, char *, void *)
#define Avladdsb Avlnode avladdsb(Avlnode *, char *, void *)
#define Avlend void avlend(Avlnode)
#define Avlsrch Avlnode avlsrch(Avlnode , char *)
#define Avltree Avlnode avltree(Avlnode *, Avlnode)
#define Axesok Aplcb axesok(Aplcb, int, int)
#define Axisdft int axisdft(Codes *, Aplcb)
#define Axispre int axispre(Aplcb, int, int *, int *, int *)
#define Axistest int axistest(Apltoken)
#define Binom double binom(double, double)
#define Binomp void binomp(double *, double *, double *)
#define Binomx void binomx(double *, double *, double *)
#define Cat Aplcb cat(Aplcb, Aplcb, int)
#define Catlamcm Aplcb catlamcm(Aplcb, Aplcb, Aplcb,\
      int, int, int, int, int, int)
#define Cdyadic Aplcb cdyadic(int (*oper)(char,char), Aplcb, Aplcb)
#define Cdyadsub CSUB cdyadsub(int, int *)
#define Ceil double ceil(double)
#define Ceilp void ceilp(double *, double *)
#define Ceilx void ceilx(double *, double *)
#define Ceq int ceq(char, char)
#define Ceqp void ceqp(char *, char *, int *)
#define Ceqpd void ceqpd(char *, char *, double *)
#define Charcode int charcode(char *)
#define Chrcopy void *chrcopy(void *, void *, int, int)
#define Chrvect Aplcb chrvect(char *)
#define Circular double circular(double, double)
#define Circulap void circulap(double *, double *, double *)
#define Circulas void circulas(double *, double *, double *)
#define Circulat void circulat(double *, double *, double *)
#define Circulav void circulav(double *, double *, double *)
#define Circulaw void circulaw(double *, double *, double *)
#define Circulax void circulax(double *, double *, double *)
#define Circulay void circulay(double *, double *, double *)
#define Circulaz void circulaz(double *, double *, double *)
#define Cne int cne(char, char)
#define Cnep void cnep(char *, char *, int *)
#define Cnepd void cnepd(char *, char *, double *)
#define Codechar char *codechar(int)
#define Comexpa Aplcb comexpa(Aplcb, Aplcb, int*, int*, int*, int*)
#define Comexpb Aplcb comexpb(Aplcb, int, int, int, int, int*)
#define Complex Aplcb complex(Aplcb)
#define Compress Aplcb compress(Aplcb, Aplcb, int)
#define Comprest void comprest(Aplcb, Aplcb, Aplcb, \
	int, int, int, int, int, int)
#define Compute Aplcb compute(Aplcb)
#define Conform int conform(Aplcb, Aplcb, int, Aplcb *, Aplcb *)
#define Conjug double conjug(double)
#define Conjugp void conjugp(double *, double *)
#define Conjugx void conjugx(double *, double *)
#define Convect Aplcb convect(int *, int, int)
#define Convert Aplcb convert(Aplcb, int)
#define Cos double cos(double)
#define Cplxin int cplxin(char *, double *, int *, int *, char *)
#define Creduce Aplcb creduce(int (*oper)(char,char), int *, Aplcb, int)
#define Creduces Aplcb creduces(int, int (*oper)(char,char), void *,\
		Aplcb, int)
#define Cscan Aplcb cscan(int (*oper)(char,char), int *, Aplcb, int)
#define Dabs double dabs(double)
#define Dabsp void dabsp(double *, double *)
#define Dabsx void dabsx(double *, double *)
#define Dbland double dbland(double, double)
#define Dblandp void dblandp(double *, double *, double *)
#define Dblcopy void *dblcopy(void *, void *, int, int)
#define Dbleq double dbleq(double, double)
#define Dbleqp void dbleqp(double *, double *, double *)
#define Dblge double dblge(double, double)
#define Dblgep void dblgep(double *, double *, double *)
#define Dblgt double dblgt(double, double)
#define Dblgtp void dblgtp(double *, double *, double *)
#define Dblle double dblle(double, double)
#define Dbllep void dbllep(double *, double *, double *)
#define Dbllt double dbllt(double, double)
#define Dblltp void dblltp(double *, double *, double *)
#define Dblmax double dblmax(double, double)
#define Dblmaxp void dblmaxp(double *, double *, double *)
#define Dblmin double dblmin(double, double)
#define Dblminp void dblminp(double *, double *, double *)
#define Dblnand double dblnand(double, double)
#define Dblnandp void dblnandp(double *, double *, double *)
#define Dblne double dblne(double, double)
#define Dblnep void dblnep(double *, double *, double *)
#define Dblnor double dblnor(double, double)
#define Dblnorp void dblnorp(double *, double *, double *)
#define Dblnot double dblnot(double)
#define Dblnotp void dblnotp(double *, double *)
#define Dblor double dblor(double, double)
#define Dblorp void dblorp(double *, double *, double *)
#define Deal Aplcb deal(Aplcb, Aplcb)
#define Decodbl Aplcb decodbl(Aplcb, Aplcb)
#define Decode Aplcb decode(Aplcb, Aplcb)
#define Decodeb Aplcb decodeb(Aplcb, Aplcb, Aplcb, int,\
          void *, void *, void *, int, int, int, int,\
          int, int, int, int)
#define Decodec Aplcb decodec(Aplcb, Aplcb, Aplcb, int,\
          void *, void *, void *, int, int, int, int,\
          int, int, int, int)
#define Depth Aplcb depth(Aplcb)
#define Depthsub int depthsub(Aplcb)
#define Dequeue void *dequeue(void *, void *)
#define Derived Aplcb derived(void *, Aplcb, Aplcb)
#define Dervfree void dervfree(Aplderiv)
#define Digits int digits(double)
#define Disclose Aplcb disclose(Aplcb, Aplcb)
#define Disclosh void disclosh(int, int *, Aplcb *, int, int, int,\
          char *, int, int *, int *, int *, int *)
#define Divide double divide(double, double)
#define Dividep void dividep(double *, double *, double *)
#define Dividex void dividex(double *, double *, double *)
#define Dottran int dottran(Apltoken)
#define Drop Aplcb drop(Aplcb, Aplcb)
#define Drop2 Aplcb drop2(Aplcb, Aplcb, Aplcb)
#define Dtacopy void *dtacopy(void *, void *, int, int, int)
#define Dublin int dublin(char *, double *, int *, int *, char *)
#define Dublins int dublins(char*, char*, char**, int*, double*, double*)
#define Dyadcom SCALAR_PROC dyadcom(void*, int*, int*, int, int)
#define Dyadic Aplcb dyadic(double (*oper)(), Aplcb, Aplcb)
#define Dyadicm Aplcb dyadicm(Aplcb, Aplcb, void **, void **,\
          void **, int *, int *, int)
#define Dyadicp Aplcb dyadicp(void*, Aplcb, Aplcb)
#define Dyadopec SCALAR_PROC dyadopec(void*, int*, int*, int, int, int)
#define Dyadoper SCALAR_PROC dyadoper(void*, int*, int*, int, int, int, int)
#define Dyadrun Aplcb dyadrun(void (*oper)(), Aplcb, Aplcb, Aplcb)
#define Dyadrup Aplcb dyadrup(Aplcb, int)
#define Dyadset SCALAR_PROC dyadset(void*, Aplcb*, Aplcb*, int*)
#define Dyadsub SUB dyadsub(int, double *)
#define Each Aplcb each(Aplderiv, Aplcb, Aplcb)
#define Eachalc Aplcb eachalc(Aplcb)
#define Eachdyad Aplcb eachdyad(Aplderiv, Aplcb, Aplcb)
#define Eachdyae Aplcb eachdyae(Aplderiv, Aplcb, Aplcb)
#define Eachdyaf Aplcb eachdyaf(Aplderiv, Aplcb, Aplcb)
#define Eachdyag Aplcb eachdyag(Aplderiv, Deriv_sub *, Aplcb, Aplcb)
#define Eachdyah Aplcb eachdyah(int, Aplcb, Aplcb)
#define Eachmona Aplcb eachmona(Aplderiv, Aplcb)
#define Eachmonb Aplcb eachmonb(Aplderiv, Aplcb)
#define Eachtran int eachtran(Apltoken)
#define Eachwrk Aplcb eachwrk(Aplcb)
#define Edline int edline(char *, int, int, int)
#define Edlinf void edlinf(char *, int *, int)
#define Edling void edling(char *, int *, int, int)
#define Enclose Aplcb enclose(Aplcb, Aplcb)
#define Enclosf Aplcb enclosf(Aplcb, Aplcb)
#define Encodbl Aplcb encodbl(Aplcb, Aplcb)
#define Encode Aplcb encode(Aplcb, Aplcb)
#define Encodeb void encodeb(Aplcb, Aplcb, Aplcb,\
		double*, double*, double*)
#define Encodec void encodec(Aplcb, Aplcb, Aplcb,\
		int*, int*, int*)
#define Endoper void endoper(Aplcb)
#define Enlist Aplcb enlist(Aplcb)
#define Enlista void enlista(int *, int *, Aplcb)
#define Enlistb char *enlistb(int, int, char *, Aplcb)
#define Enlistc Aplcb enlistc(Apltoken, char *, Aplcb)
#define Enlistd int enlistd(Aplcb, Aplcb *, int)
#define Enqueue void enqueue(void *, void *, void *)
#define Eq int eq(double, double)
#define Eqp  void eqp(double *, double *, int *)
#define Eqx void eqx(double *, double *, int *)
#define Errinit int errinit(void)
#define Errstop Aplcb errstop(int, Aplcb, Aplcb, Aplcb)
#define Execalt Aplcb execalt(Aplcb, Aplcb)
#define Execasgn Aplcb execasgn(Apltoken, Aplcb)
#define Execaxis Aplcb execaxis(void *)
#define Execaxit Aplcb execaxit(Apltoken)
#define Execaxiv double execaxiv(Aplcb)
#define Execbrkt Apltoken execbrkt(Apltoken)
#define Execdot Aplcb execdot(Aplderiv, Aplcb, Aplcb)
#define Execdota Aplcb execdota(Aplcb, Aplcb, int, void *, void *)
#define Execdotb Aplcb execdotb(Aplcb, Aplcb, int, int, int, int)
#define Execdotc Aplcb execdotc(Aplcb, Aplcb, int, int,\
          Scalar_dyadics*, Scalar_dyadics*)
#define Execdotd Aplcb execdotd(Aplcb, Aplcb, int, int, Aplderiv)
#define Execdote Aplcb execdote(Aplderiv, Aplcb, Aplcb)
#define Execdotf Aplcb execdotf(Aplderiv, Aplcb, Aplcb)
#define Execdotg Aplcb execdotg(Aplderiv, Aplcb, Aplcb)
#define Execdyac Apltoken execdyac(Apltoken, Apltoken,\
          Aplcb, Aplcb, Aplcb, int)
#define Execdyad Apltoken execdyad(Apltoken, Apltoken)
#define Execdyae Aplcb execdyae(Aplcb, Aplcb, int)
#define Execdyaf Aplcb execdyaf(Aplcb, Aplcb, int)
#define Execdyag Aplcb execdyag(Aplcb, Aplcb, int)
#define Execdyah int execdyah(Apltoken)
#define Execdyai Aplcb execdyai(Aplcb, Aplcb, int)
#define Execdyaj Aplcb execdyaj(void *, Aplcb, Aplcb)
#define Execdyak Aplcb execdyak(void *, Aplcb, Aplcb, int)
#define Execdyal Aplcb execdyal(void *, Aplcb, Aplcb)
#define Execdyam Aplcb execdyam(void *, Aplcb, Aplcb)
#define Execdyan Aplcb execdyan(int, void *, Aplcb, Aplcb)
#define Execdyap sub_dyad execdyap(void *, void **)
#define Execdyaq sub_dyad execdyaq(void *)
#define Execdyar sub_dyad execdyar(void *)
#define Execdyas int execdyas(void *, void **, sub_dyad *)
#define Execdyat Aplcb execdyat(void *, Aplcb, Aplcb, \
			  Aplcb (*oper)(void *, Aplcb, Aplcb))
#define Execdyau sub_dyad execdyau(void *)
#define Execdyav sub_dyad execdyav(void *)
#define Execexec Apltoken execexec(void)
#define Execexed void execexed(void)
#define Execexee int execexee(Apltoken *, Apltoken *)
#define Execexef Apltoken execexef(Apltoken)
#define Execexeg Apltoken execexeg(void)
#define Execexeh int execexeh(Apltoken)
#define Execexei int execexei(Apltoken *, Apltoken *, Apltoken)
#define Execexej Apltoken execexej(void)
#define Execexek Apltoken execexek(void)
#define Execfree void execfree(Apltoken)
#define Execfun int execfun(void **)
#define Execgeto Aplcb execgeto(void *)
#define Execgetp Aplcb execgetp(Apltoken)
#define Execgetq Aplcb execgetq(Apltoken)
#define Execgetr Aplcb execgetr(Apltoken)
#define Execgets Aplcb execgets(Apltoken)
#define Execglc Aplcb execglc(void)
#define Execindx Apltoken execindx(Apltoken)
#define Execindy Aplcb execindy(Apltoken, int)
#define Execinit void execinit(void)
#define Execjot Aplcb execjot(Aplderiv, Aplcb, Aplcb)
#define Execjot2 Aplcb execjot2(Aplderiv, Aplcb, Aplcb)
#define Execjota Aplcb execjota(Aplcb, Aplcb, int, Scalar_dyadics *)
#define Execjotc Aplcb execjotc(Aplcb, Aplcb, int, int, Scalar_dyadics *)
#define Execjotd Aplcb execjotd(Aplcb, Aplcb, int, int, void *)
#define Execmona void execmona(Apltoken)
#define Execmonb Aplcb execmonb(Aplcb, Apltoken, int, int)
#define Execmong void execmong(void)
#define Execmonh void execmonh(void)
#define Execmoni int execmoni(void *, void **, sub_dyad *)
#define Execmonj Aplcb execmonj(deriv_type, void *, void *, sub_dyad,\
          Aplcb, Aplcb)
#define Execmonk Aplcb execmonk(deriv_type,         void *, sub_dyad,\
          Aplcb, int *)
#define Execmonq int execmonq(int, sub_dyad *)
#define Execmons int execmons(int, void *, void **, sub_dyad *)
#define Execmsg void execmsg(char *, int, int, char *)
#define Execnexs int execnexs(Apltoken*, Apltoken*, Apltoken,\
		int*, int*, int, int)
#define Execnext int execnext(Apltoken *, Apltoken *, Apltoken *, int *)
#define Execnexu int execnexu(Apltoken*, Apltoken*, Apltoken*,\
		int*, int*, int)
#define Execnila Apltoken execnila(Apltoken)
#define Execopck Apltoken execopck(Apltoken)
#define Execoptk Apltoken execoptk(Apltoken *)
#define Execout void execout(Aplcb, int)
#define Execpars Apltoken execpars(char *, int)
#define Execpop void execpop(Apltoken *)
#define Execqcr Aplcb execqcr(Aplcb)
#define Execqdl Aplcb execqdl(Aplcb)
#define Execqex Aplcb execqex(Aplcb)
#define Execqext int execqext()
#define Execqfx Aplcb execqfx(Aplcb)
#define Execqfxa Aplfunc execqfxa(Aplcb)
#define Execqfxb void execqfxb(Aplfunc)
#define Execqfxc Apltoken execqfxc(Apltoken, Apltoken)
#define Execqfxd Apltoken execqfxd(Aplfunc)
#define Execqfxe Apltoken execqfxe(Apltoken, int, int)
#define Execqfxf void execqfxf(Aplfunc)
#define Execqfxg Apltoken execqfxg(Aplfunc, Apltoken, int, Apltoken)
#define Execqfxh void execqfxh(Aplfunc, Apltoken,  Apltoken,\
          int, Apltoken)
#define Execqfxi void execqfxi(Aplfunc)
#define Execqfxj void execqfxj(Aplfunc)
#define Execqfxk void execqfxk(Aplfunc)
#define Execqfxl Apltoken execqfxl(Aplfunc)
#define Execqfxm Aplcb execqfxm(Apltoken, Aplfunc)
#define Execqnc Aplcb execqnc(Aplcb)
#define Execqncs Aplcb execqncs(int (*oper)(), Aplcb)
#define Execqnl Aplcb execqnl(Aplcb, Aplcb)
#define Execqnls void execqnls(Avlnode , struct nlparm *)
#define Execqnlt int execqnlt(char *, char *)
#define Execqnlu Aplcb execqnlu(struct nlparm *)
#define Execqts Aplcb execqts(void)
#define Execqtz Aplcb execqtz(void)
#define Execqtzs double execqtzs(void)
#define Execspec int execspec(Apltoken *)
#define Execsped int execsped(Apltoken, Apltoken)
#define Execspee int execspee(Apltoken, Apltoken, Apltoken, int)
#define Execspef Apltoken execspef(Apltoken, Aplcb, Aplcb, Aplcb, int)
#define Execspeg Aplcb execspeg(Apltoken, Apltoken, Apltoken, int *)
#define Execspeh int execspeh(Aplcb *, Aplcb, Aplcb, int *, int)
#define Execspei int execspei(Aplcb *, Aplcb, Aplcb, int)
#define Execspej int execspej(Aplcb *, Aplcb, int)
#define Execspek int execspek(int, Apltoken, Apltoken, Apltoken)
#define Execspel int execspel(Apltoken *, Apltoken *)
#define Execspen int execspen(Aplcb *, Aplcb, Aplcb, int *, int)
#define Execspep int execspep()
#define Execspeq Apltoken execspeq(Avlnode *)
#define Execsper int execsper(Avlnode , Aplcb, Apltoken)
#define Execspes Aplcb execspes(Aplcb)
#define Execspeu Aplcb execspeu(Aplcb, int*) /* was (int, int) */
#define Execspex int execspex()
#define Execspey int execspey(Apltoken)
#define Execspez Aplcb execspez(Apltoken, Apltoken, Apltoken, Aplcb, Aplcb,\
	int*)
#define Execterm void execterm(void)
#define Exectok Apltoken exectok(Aplcb, int)
#define Exectokf Aplcb exectokf(Apltoken)
#define Execute Aplcb execute(Aplcb)
#define Executf Aplcb executf(Aplcb)
#define Executg Aplcb executg(Aplcb)
#define Exp double exp(double)
#define Expp void expp(double *, double *)
#define Expx void expx(double *, double *)
#define Expand Aplcb expand(Aplcb, Aplcb, int)
#define Expane Aplcb expane(Aplcb, Aplcb, Aplcb, int, int, int, int)
#define Expanf Aplcb expanf(int, int, int, int, int, Aplcb)
#define Expunge void *expunge(Aplfunc)
#define Expungf void *expungf(Apltoken, int)
#define Factorl double factorl(double)
#define Factorlp void factorlp(double *, double *)
#define Factorlx void factorlx(double *, double *)
#define Fifo void *fifo(void *, void *, void *)
#define Find Aplcb find(Aplcb, Aplcb)
#define First Aplcb first(Aplcb)
#define Floor double floor(double)
#define Floorp void floorp(double *, double *)
#define Floorx void floorx(double *, double *)
#define Fmod double fmod(double, double)
#define Form Aplcb form(Aplcb, Aplcb)
#define Formata Aplcb formata(Aplcb, Aplcb)
#define Formatb Aplcb formatb(Aplcb, Aplcb)
#define Formatc void formatc(Aplcb)
#define Formatd void formatd(Aplcb, Aplcb, Aplcb)
#define Formate int formate(Aplcb, Aplcb)
#define Formatf int formatf(Aplcb, Aplcb)
#define Formatg Aplcb formatg(Aplcb, Aplcb, Aplcb)
#define Formath void formath(double d, char *, int, int, int, char *)
#define Formati Aplcb formati(Aplcb, Aplcb*)
#define Formatj void formatj(Aplcb, Aplcb)
#define Formatk Aplcb formatk(Aplcb, Aplcb, Aplcb)
#define Formatl char *formatl(char *, char *, char **)
#define Formatm void formatm(Aplcb, Aplcb, Aplcb)
#define Formatn char *formatn(char *, int, int)
#define Formato void formato(char*, char, char**,\
		int*, int*, int*, int*)
#define Formatp Aplcb formatp(Aplcb, Aplcb)
#define Formatq Aplcb formatq(Aplcb, Aplcb, int, int, int, int, char*)
#define Formatr char *formatr(char *, char *, double, char *)
#define Formats void formats(char*, char**, int*)
#define Formatt char *formatt(char*, double, int)
#define Formatu void formatu(int*, int*, int, char*, char)
#define Formatv char *formatv(char*, char*, char**, int*, char**, int*, int)
#define Formatw void formatw(char**, int*, int, char*, char*)
#define Formatx double formatx(Aplcb, int, int, int, int*, int*, int*)
#define Formaty char *formaty(void)
#define Formatz void formatz(Aplcb, char *, int, int, int, char *, int)
#define Formben int formben(double, char*, int, int, int, char*, char*)
#define Formbfn int formbfn(double, char*, int, int, int, char*, char*)
#define Formbfv void formbfv(char*, char*, char**, char**, char*, char*, \
	char**,int*,int,int,int,int,int)
#define Formbfw char formbfw(char,char*,int,char**,int*)
#define Formbfx char formbfx(char**,char*,char**,char*)
#define Formbtk void formbtk(Aplcb, Aplcb, Aplcb)
#define Formdfs Aplcb formdfs(Aplcb)
#define Formdft Aplcb formdft(Aplcb)
#define Formdfu Aplcb formdfu(int, int, int, int, int *, int *,\
          Aplcb *, Aplcb *, Aplcb *,\
          Aplcb, Aplcb, Aplcb, Aplcb, Aplcb, Aplcb, Aplcb, Aplcb, Aplcb)
#define Formdfv int formdfv(Aplcb, Aplcb)
#define Formdfw Aplcb formdfw(Aplcb)
#define Formdfx Aplcb formdfx(int, int, int, int,\
          Aplcb, Aplcb, Aplcb, Aplcb, Aplcb, Aplcb, Aplcb)
#define Formdfy Aplcb formdfy(Aplcb)
#define Formdfz Aplcb formdfz(int, int, int)
#define Formldm int formldm(Aplcb, Aplcb, Aplcb)
#define Formota void formota(char*, char, char**,\
		int*, int*, int*, int*)
#define Formotb void formotb(char*, char, char**,\
		int*, int*, int*, int*)
#define Formsci char *formsci(char*, char*, char**, int*, char**,\
		int*, int, double, char*)
#define Formscj void formscj(char**, int*, char*, int, char*)
#define Formspp void formspp(Aplcb)
#define Funcexec void funcexec(int)
#define Funcexed Aplcb funcexed(Apltoken, int)
#define Funcexee int funcexee(Aplcb, int)
#define Funcexef int funcexef(Aplcb, int, Aplfunc, Aplcb, Apltoken)
#define Funcgoto int funcgoto(Aplfunc, Aplcb, int)
#define Funcinit void funcinit(Aplfunc, Aplcb, Aplcb)
#define Funcmain Aplcb funcmain(void *, Aplcb, Aplcb)
#define Funcmsg void funcmsg(Aplfunc, int, int)
#define Funcopy Aplfunc funcopy(Aplfunc)
#define Funcstop int funcstop(Aplcb, int)
#define Funcsusp int funcsusp(void)
#define Funcsusq int funcsusq(Aplcb, int)
#define Functrac void functrac(Aplfunc, Aplcb, int, Aplcb)
#define Functrgo void functrgo(Aplfunc, Aplcb, int, int)
#define Functrst Aplcb functrst(char *, char *)
#define Funexec Apltoken funexec(Apltoken)
#define Funinit void funinit(void)
#define Gammax void gammax(double *, double *, int)
#define Ge int ge(double, double)
#define Gep void gep(double *, double *, int *)
#define Genint Aplcb genint(Aplcb, int)
#define Getcb Aplcb getcb(void *, int, int, int, int *)
#define Getcbi Aplcb getcbi(void *, int, int, int, int *)
#define Getchrv Aplcb getchrv(char *)
#define Getcode int getcode(void **, Apltoken)
#define Getfact Aplcb getfact(Aplcb)
#define Gettcom int gettcom(char *, int, int, int, int)
#define Gettext int gettext(char *, int)
#define Getvect Aplcb getvect(char *)
#define Grade Aplcb grade(Aplcb, int)
#define Grade2 Aplcb grade2(Aplcb, Aplcb, int)
#define Grade2a Aplcb grade2a(Aplcb, Aplcb, int, int, int, int)
#define Gradedn Aplcb gradedn(Aplcb)
#define Gradedn2 Aplcb gradedn2(Aplcb, Aplcb)
#define Gradesub int gradesub(Aplcb, int, int, int)
#define Gradeup Aplcb gradeup(Aplcb)
#define Gradeup2 Aplcb gradeup2(Aplcb, Aplcb)
#define Gt int gt(double, double)
#define Gtp void gtp(double *, double *, int *)
#define Iabs int iabs(int)
#define Iabsp void iabsp(int *, int *)
#define Iand int iand(int, int)
#define Iandp void iandp(int *, int *, int *)
#define Ibinom int ibinom(int, int)
#define Ibinomp void ibinomp(int *, int *, int *)
#define Iconjug int iconjug(int)
#define Iconjugp void iconjugp(int *, int *)
#define Idivide int idivide(int, int)
#define Idyadic Aplcb idyadic(int (*oper)(), Aplcb, Aplcb)
#define Idyadsub ISUB idyadsub(int, int*)
#define Ieq int ieq(int, int)
#define Ieqp void ieqp(int *, int *, int *)
#define Ifactorl int ifactorl(int)
#define Ifactorp void ifactorp(int *, int *)
#define Ige int ige(int, int)
#define Igep void igep(int *, int *, int *)
#define Igt int igt(int, int)
#define Igtp void igtp(int *, int *, int *)
#define Ile int ile(int, int)
#define Ilep void ilep(int *, int *, int *)
#define Ilt int ilt(int, int)
#define Iltp void iltp(int *, int *, int *)
#define Imax int imax(int, int)
#define Imaxp void imaxp(int *, int *, int *)
#define Imin int imin(int, int)
#define Iminp void iminp(int *, int *, int *)
#define Iminus int iminus(int, int)
#define Imod int imod(int, int)
#define Imonadic Aplcb imonadic(int (*oper)(), Aplcb)
#define Inand int inand(int, int)
#define Inandp void inandp(int *, int *, int *)
#define Indexgen Aplcb indexgen(Aplcb)
#define Indexm Aplcb indexm(Aplcb, Aplcb, Aplcb)
#define Indexma Aplcb indexma(void *)
#define Indexmb int *indexmb(int, void *, Aplcb *, int, int *, char *)
#define Indexno int indexno(int, int *, int *, int *, int)
#define Indexof Aplcb indexof(Aplcb, Aplcb)
#define Indexv Aplcb indexv(Aplcb, Aplcb, Aplcb)
#define Indices void indices(int *, int *, int *, int, int)
#define Indxsub Aplcb indxsub(int)
#define Ine int ine(int, int)
#define Inep void inep(int *, int *, int *)
#define Inegativ int inegativ(int)
#define Inegatip void inegatip(int *, int *)
#define Innrcom Aplcb innrcom(int, Aplcb, Aplcb, int *,\
          int *, int *, int *, int *,\
          int *, int *, int *, int *,\
          int *, char **, char **, char **)
#define Innrprd Aplcb innrprd(void *, void *,\
          void *, Aplcb, Aplcb)
#define Innrprda Aplcb innrprda(Aplcb, Aplcb, int)
#define Innrprdb Aplcb innrprdb(Aplcb, Aplcb,\
          double (*opera)(), double (*operb)(), double *,\
          Aplcb, int,\
          double *, double *, double *,\
		int, int, int, int, int, int, int, int)
#define Innrprdc Aplcb innrprdc(Aplcb, Aplcb,\
          int (*opera)(), int (*operb)(), int *,\
          Aplcb, int,\
          int *, int *, int *,\
		int, int, int, int, int, int, int, int)
#define Innrprdd Aplcb innrprdd(Aplcb, Aplcb,\
          int (*opera)(), int (*operb)(), int *,\
          Aplcb, int,\
		int *, char *, char *,\
          int, int, int, int, int, int, int, int)
#define Innrprde Aplcb innrprde()
#define Innrprdp Aplcb innrprdp(void *, void *,\
          void *, Aplcb, Aplcb)
#define Innrprdq Aplcb innrprdq(void *, void *,\
          void *, Aplcb, Aplcb)
#define Innrprdx Aplcb innrprdx(void (*opera)(), int, double,\
          Aplcb, Aplcb)
#define Inor int inor(int, int)
#define Inorp void inorp(int *, int *, int *)
#define Inot int inot(int)
#define Intcopy void *intcopy(void *, void *, int, int)
#define Integer Aplcb integer(Aplcb)
#define Integes Aplcb integes(Aplcb, Aplcb)
#define Intone void intone(void *, void *, int *)
#define Inttran void inttran(int *, double *, int, int)
#define Intzero void intzero(void *, void *, int *)
#define Invert double *invert(double *, int)
#define Ior int ior(int, int)
#define Iorder void iorder(Aplcb)
#define Iorp void iorp(int *, int *, int *)
#define Iplus int iplus(int, int)
#define Ireduce Aplcb ireduce(int (*oper)(), int *, Aplcb, int)
#define Ireduces Aplcb ireduces(int, int (*oper)(), int *, Aplcb, int)
#define Iresidu int iresidu(int, int)
#define Iroll int iroll(int)
#define Irollp void irollp(int*, int*)
#define Iscalar Aplcb iscalar(int)
#define Iscan Aplcb iscan(int (*oper)(), int *, Aplcb, int)
#define Isign int isign(int)
#define Isignp void isignp(int *, int *)
#define Itimes int itimes(int, int)
#define Ivalue int ivalue(Aplcb)
#define Laminate Aplcb laminate(Aplcb, Aplcb, double)
#define Le int le(double, double)
#define Lep void lep(double *, double *, int *)
#define Leafdel void leafdel(Aplcb)
#define Lifo void *lifo(void *, void *)
#define Litvect Aplcb litvect(char *)
#define Log double log(double)
#define Logamma void logamma(double *, double *)
#define Logp void logp(double *, double *)
#define Logx void logx(double *, double *)
#define Logrithm double logrithm(double, double)
#define Logrithp void logrithp(double *, double *, double *)
#define Logrithx void logrithx(double *, double *, double *)
#define Lovfscb Aplcb lovfscb(int, int)
#define Lovfsfn Aplfunc lovfsfn(int, int)
#define Lovfsfo Aplfunc lovfsfo(int, Aplfunc)
#define Lovfsfp Aplfunc lovfsfp(int, Aplfunc, int)
#define Lt int lt(double, double)
#define Ltp void ltp(double *, double *, int *)
#define Match Aplcb match(Aplcb, Aplcb)
#define Matchget Aplcb matchget(Aplcb, int)
#define Matchok int matchok(Aplcb *, Aplcb *, int)
#define Matchoks int matchoks(Aplcb *, Aplcb *, int)
#define Matchokt int matchokt(Aplcb *, Aplcb *, int, int, int)
#define Matchsub int matchsub(int, char *, char *)
#define Matinv Aplcb matinv(Aplcb)
#define Matmult double *matmult(double*, double*, int, int, int)
#define Mdivarg int mdivarg(Aplcb, int *, int *)
#define Mdivide Aplcb mdivide(Aplcb, Aplcb)
#define Member Aplcb member(Aplcb, Aplcb)
#define Memixb Aplcb memixb(int, Aplcb, Aplcb, Aplcb)
#define Memixc Aplcb memixc(int, Aplcb, Aplcb, Aplcb)
#define Memixcm Aplcb memixcm(int, Aplcb, Aplcb)
#define Memixd Aplcb memixd(int, Aplcb, Aplcb, Aplcb)
#define Memixe Aplcb memixe(int, Aplcb, Aplcb, Aplcb)
#define Memixf Aplcb memixf(int, Aplcb, Aplcb, Aplcb)
#define Min double min(double, double)
#define Minus double minus(double, double)
#define Minusp void minusp(double *, double *, double *)
#define Minusx void minusx(double *, double *, double *)
#define Mod double mod(double, double)
#define Monadic Aplcb monadic(double (*oper)(), Aplcb)
#define Monfront Aplcb monfront(void *, Aplcb)
#define Multset void multset(int, int *, int *)
#define Namelen int namelen(char *, int, int, char **)
#define Nand int nand(double, double)
#define Nandp void nandp(double *, double *, int *)
#define Ne int ne(double, double)
#define Nep  void nep(double *, double *, int *)
#define Nex void nex(double *, double *, int *)
#define Negative double negative(double)
#define Negativp void negativp(double *, double *)
#define Negativx void negativx(double *, double *)
#define Nestchar Aplcb nestchar(Aplcb)
#define Newderiv Aplderiv newderiv(Aplcb, Aplcb, Aplcb)
#define Newtok Apltoken newtok(int, int, int, char *, int)
#define Nomatchp void nomatchp(void *, void *, void *)
#define Nor int nor(double, double)
#define Norp void norp(double *, double *, int *)
#define Not int not(double)
#define Nreduce Aplcb nreduce(Aplderiv, Aplcb, int)
#define Nreduces Aplcb nreduces(int, Aplderiv, Aplcb, int)
#define Nscan Aplcb nscan(Aplderiv, Aplcb, int)
#define Nwise Aplcb nwise(Aplderiv, Aplcb, Aplcb, int)
#define Offtptr char *offtptr(char *, int)
#define Or int or(double, double)
#define Orp void orp(double *, double *, int *)
#define Outrprd Aplcb outrprd(void *, Aplcb, Aplcb)
#define Outrprdb void outrprdb(double *, double *, double *, int, int,\
          double (*oper)())
#define Outrprdc void outrprdc(int *, int *, int *, int, int,\
          int (*oper)())
#define Outrprdd void outrprdd(char *, char *, char *, int, int,\
          int (*oper)())
#define Outrprdp Aplcb outrprdp(void *, Aplcb, Aplcb)
#define Outrprdx Aplcb outrprdx(int, Aplcb, Aplcb)
#define Partitn Aplcb partitn(Aplcb, Aplcb, Aplcb)
#define Partito Aplcb partito(Aplcb, Aplcb, Aplcb, int)
#define Partitp Aplcb partitp(Aplcb, Aplcb,\
		int, int, int, int, int, int, int, int)
#define Perm Aplcb perm(Aplcb)
#define Pick Aplcb pick(Aplcb, Aplcb, Aplcb)
#define Picks Aplcb picks(Apltoken, char *, Aplcb)
#define Pickdyad Scalar_dyadics *pickdyad(void *)
#define Pitimes double pitimes(double)
#define Pitimesp void pitimesp(double *, double *)
#define Pitimesx void pitimesx(double *, double *)
#define Places int places(double,int,int)
#define Plus double plus(double, double)
#define Plusp void plusp(double *, double *, double *)
#define Plusx void plusx(double *, double *, double *)
#define Pop void *pop(void *)
#define Popnesc void popnesc(void *, Aplcb)
#define Popnest Apltoken popnest(Apltoken *)
#define Popnesu Apltoken popnesu(void *, Aplcb)
#define Popnesv void popnesv(void *, Aplcb)
#define Popnesw void popnesw(void *, Aplcb)
#define Popnesx void popnesx(void *, Aplcb)
#define Pow double pow(double, double)
#define Power double power(double, double)
#define Powerp void powerp(double *, double *, double *)
#define Powerpx void powerpx(double*, double*, double*, double*,\
		double, double)
#define Powerx void powerx(double *, double *, double *)
#define Precisn void precisn(double, int*)
#define Preduce Aplcb preduce(Aplderiv, Aplcb, int)
#define Preduces Aplcb preduces(int, Aplderiv, Aplcb, int)
#define Preducet void preducet(int, int, int, int, int, int, \
	Aplcb, Aplcb, SCALAR_PROC, char*)
#define Prompt char *prompt(char *)
#define Ptrtoff int ptrtoff(char *, char *)
#define Qquadin Aplcb qquadin(void)
#define Qquadout Aplcb qquadout(Aplcb)
#define Quadin Aplcb quadin(void)
#define Quadinit void quadinit(void)
#define Quadname char *quadname(char *)
#define Quadnami char *quadnami(int)
#define Quadout Aplcb quadout(Aplcb)
#define Quadoutc Aplcb quadoutc(Aplcb, int)
#define Quadrec void quadrec(int, int *, char **, int)
#define Quoteit void quoteit(char *, char *)
#define Ravel Aplcb ravel(Aplcb)
#define Ravel2 Aplcb ravel2(Aplcb, Aplcb)
#define Real Aplcb real(Aplcb)
#define Recip double recip(double)
#define Recipp void recipp(double *, double *)
#define Recipx void recipx(double *, double *)
#define Redscan Aplcb redscan(int, Aplderiv, Aplcb, int, \
		Aplcb (*crs)(int (*oper)(char,char), int *, Aplcb, int), \
          Aplcb (*nrs)(Aplderiv, Aplcb, int))
#define Reduce Aplcb reduce(double (*oper)(), double *, Aplcb, int)
#define Reducecm Aplcb reducecm(int, void *, Aplcb, int *,\
          int *, int *, int *, int)
#define Reducef Aplcb reducef(Aplderiv, Aplcb, Aplcb)
#define Reducesb Aplcb reducesb(int, double (*oper)(), double *,\
          Aplcb, int)
#define Regress double *regress(Aplcb, Aplcb, int, int, int, int)
#define Regrest double *regrest(Aplcb, Aplcb, int, int, int, int,\
          double *, Aplcb, Aplcb)
#define Relative Aplcb relative(int (*oper)(), Aplcb, Aplcb)
#define Relativf Aplcb relativf(int (*oper)(), Aplcb, Aplcb, int)
#define Reshape Aplcb reshape(Aplcb, Aplcb)
#define Residue double residue(double, double)
#define Residuep void residuep(double *, double *, double *)
#define Residuex void residuex(double *, double *, double *)
#define Reverse Aplcb reverse(Aplcb, int)
#define Revrot Aplcb revrot(Aplcb, int, int *, int *, int *)
#define Rmonadic Aplcb rmonadic(int (*oper)(), Aplcb)
#define Roll double roll(double)
#define Rollp void rollp(double *, double *)
#define Rotate Aplcb rotate(Aplcb, Aplcb, int)
#define Rotatesb Aplcb rotatesb(Aplcb, Aplcb, Aplcb,\
          int, int, int, int, int)
#define Savfscb void savfscb(int, Aplcb)
#define Savfsfn void savfsfn(int, Aplfunc)
#define Savfsfo void savfsfo(int, Aplfunc)
#define Savfsub void savfsub(int, Avlnode)
#define Savlist void savlist(int, Apltoken, Apltoken)
#define Scalar Aplcb scalar(double)
#define Scalax Aplcb scalax(void *, Aplcb, Aplcb, Aplcb)
#define Scalay void *scalay(void *, int, int, int)
#define Scalaz Aplcb scalaz(void *, Aplcb, Aplcb, Aplcb,\
		Aplcb *, Aplcb *, int *, int *, int *, int *, int)
#define Scan Aplcb scan(double (*oper)(), double *, Aplcb, int)
#define Scanfrnt Aplcb scanfrnt(Aplderiv, Aplcb, Aplcb)
#define Setix int setix(Aplcb, int, Aplcb)
#define Shape Aplcb shape(Aplcb)
#define Signdbl double signdbl(double)
#define Signdblp void signdblp(double *, double *)
#define Signdblx void signdblx(double *, double *)
#define Signum int signum(double)
#define Sin double sin(double)
#define Slasherr void slasherr(Apltoken, Apltoken, Apltoken, Aplderiv)
#define Slashtra int slashtra(Apltoken)
#define Slashtrb void slashtrb(Apltoken, Apltoken, Apltoken, Aplderiv)
#define Slashtrc void slashtrc(Apltoken, Apltoken, Aplderiv)
#define Squadix Aplcb squadix(Aplcb, Aplcb, Aplcb, Aplcb)
#define Sqrt double sqrt(double)
#define Strread char *strread(int)
#define Strwrite int strwrite(int, char *)
#define Take Aplcb take(Aplcb, Aplcb)
#define Take2 Aplcb take2(Aplcb, Aplcb, Aplcb)
#define Takeck int takeck(Aplcb *, Aplcb *)
#define Takefill char *takefill(void *)
#define Takeit Aplcb takeit(Aplcb, Aplcb)
#define Takepset Aplcb takepset(Aplcb, Aplcb, void *)
#define Takesub void takesub(int, void *)
#define Temp Aplcb temp(Aplcb)
#define Times double times(double, double)
#define Timesp void timesp(double *, double *, double *)
#define Timesx void timesx(double *, double *, double *)
#define Tokcopy void tokcopy(Apltoken, Apltoken)
#define Transpos Aplcb transpos(Aplcb, Aplcb)
#define Transpot Aplcb transpot(Aplcb, Aplcb)
#define Transpou Aplcb transpou(Aplcb, Aplcb, Aplcb, Aplcb, int)
#define Treenode Avlnode treenode(char *)
#define Treeroot Treelist treeroot(Aplfunc)
#define Treesrch void *treesrch(char *)
#define Typeget int typeget(int, int)
#define Value double value(Aplcb)
#define Vectin Aplcb vectin(Aplcb)
#define Vector Aplcb vector(char **, char *, int)
#define Vectors Aplcb vectors(int, int, Flist*)
#define Without Aplcb without(Aplcb, Aplcb)
#define Xeq int xeq(double *, double *)
#define Xeqp void xeqp(double *, double *, int *)
#endif
