/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* apltoken.h - APL2 V1.0.0 ********************************************
* Describes the structure used to tokenize APL statements.             *
* Used in subroutine aplparse.  The QUAD_xx definitions must remain    *
* negative and contiguous, with QUAD_AI first and QUAD_WA last.        *
* Token codes 256 and above are reserved for user-defined function     *
* types.  See aplfunc.h.                                               *
***********************************************************************/
#if !defined(APLTOKEN_INCL)
#define APLTOKEN_INCL
#include "apltokcd.h"
typedef struct apltoken *Apltoken;
struct apltoken {
     union {
      struct apltoken *token_next_ptr;
          /* Pointer to next token.                                   */
      int token_next_offset;
          /* Offset to next token in workspace.                       */
     } token_queue;
     int token_code;
          /* VECTOR_TOKEN, OPERAND_TOKEN, LEFT_ARROW, DERIVED_FUNCTION*/
     int token_offset;
          /* Offset in statement where token was found, or for a      */
          /* function definition, the statement number if this token  */
          /* is a label.                                              */
     union {
      char *token_string;
          /* For OPERAND_TOKEN, points to string containing the name. */
          /* For MESSAGE_TOKEN, points to message. This sort of token */
          /* only occurs during parse.                                */
      struct aplcb *token_vector;
          /* During initial parse, points to a literal vector.        */
      struct apltoken *token_stack;
          /* During execution, axis or index token stack. EXECBRKT    */
          /* creates a token with token_code AXIS_INDEX_TOKEN, and    */
          /* pushes onto its token_stack field all the indices it     */
          /* encounters between the left and right brackets.          */
      void *token_function;
          /* In APL2, expressions can evaluate to a function.         */
      struct aplderiv *token_deriv;
          /* For token_code == DERIVED_FUNCTION, points to structure  */
          /* describing the derived function, e.g. +/[1].             */
     } token_ptr;
     int token_flags;
          /*  1 = permanent token.                                    */
     void *token_work;
          /* May contain e.g. a pointer to a function definition      */
          /* during execution.                                        */
          /* EXECEXEE Initializes token_work to NIL for the function/ */
          /* operator token most recently pulled from the input.      */
          /* EXECEXEI is called by execexee when current token is     */
          /* type OPERAND_TOKEN to check if it is a defined function. */
          /* If so, execexei sets token_work to the address of the    */
          /* defined function definition structure.                   */
          /* GETCODE is called to determine operator/function code    */
          /* for a token.  If token_work is not NULL, getcode assumes */
          /* the token is for a defined function, and returns code    */
          /* DEFINED_FUNCTION (256).                                  */
          /* NEWTOK allocates new tokens.  It initializes token_work  */
          /* to NIL.                                                  */
};
#endif
