/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
#if !defined(APLDERIV_INCL)
#define APLDERIV_INCL
/* aplderiv.h - APL2 V1.0.0 ********************************************
* APL2 operators such as SLASH (reduce) produce derived functions,     *
* which are described by this structure.                               *
***********************************************************************/
#define DERPERM 1
typedef enum
	{NO_TYPE, DIX, WAX, DBX, FLR, MOA, MON, MOX, DOX, MEX, DNL, DRV}
     deriv_type;
typedef struct aplderiv *Aplderiv;
typedef union {
     Aplcb     (*dix)(Aplcb, Aplcb); /* dyad mixed w/o axis           */
     Aplcb     (*wax)(Aplcb, Aplcb, int); /* compress/expand          */
     Aplcb     (*dbx)(Aplcb, Aplcb, double); /* laminate              */
     Aplcb     (*flr)(void *, Aplcb, Aplcb); /* scalars, relat.       */
     Aplcb     (*moa)(void *, Aplcb); /* monadic scalars              */
     Aplcb     (*mon)(Aplcb); /* monadic mixed w/o axis               */
     Aplcb     (*mox)(Aplcb, int); /* monadic mixed w/axis            */
     Aplcb     (*dox)(Aplcb, Aplcb, Aplcb); /* dyadic w/axes          */
     Aplcb     (*mex)(Aplcb, Aplcb); /* monadic w/axes                */
     Aplcb     (*dnl)(Aplcb, Aplcb, Aplcb, char *); /* pick           */
     Aplcb     (*drv)(Aplderiv, Aplcb, Aplcb); /* derived function    */
} sub_dyad;
typedef struct deriv_sub Deriv_sub;
struct deriv_sub {
     int             funcode;        /* getcode type for fun          */
     void           *fun;            /* determined by funcode         */
                                     /* DERIVED_FUNCTION: Aplderiv    */
                                     /* DEFINED_FUNCTION: Aplfunc     */
                                     /* FUNCTION_TOKEN: see funstruc.h*/
                                     /* otherwise fun == NULL         */
     void           *sdp;            /* Scalar dyadics operand        */
     Aplcb           cb;             /* Array operand                 */
     deriv_type      type;           /* identifies func type          */
     sub_dyad        func;           /* dyadic sub-function           */
};
struct aplderiv {
     int             deriv_flags;    /* 1 = permanent(don't free)     */
     int             deriv_axis_int; /* axis in integer form          */
     double          deriv_axis_dbl; /* axis in real form             */
     Aplcb           deriv_axis_cb;  /* axis/axes aplcb ptr           */
     void           *deriv_op;       /* Funstruc for e.g. slope/slash */
     Aplcb         (*deriv_func)(Aplderiv, Aplcb, Aplcb); /* handles  */
                                     /* derived function processing   */
     Deriv_sub       deriv_left;     /* left operand description      */
     Deriv_sub       deriv_rite;     /* right operand description     */
};
#define DERIV_COPY(TO,FROM) {\
	TO.funcode	= FROM.funcode;\
	TO.fun		= FROM.fun;\
	TO.sdp		= FROM.sdp;\
	TO.cb		= FROM.cb;\
	TO.type		= FROM.type;}
#define APLDERIV_COPY(TO,FROM) {\
	TO.deriv_flags		= FROM.deriv_flags;\
	TO.deriv_axis_int	= FROM.deriv_axis_int;\
	TO.deriv_axis_dbl	= FROM.deriv_axis_dbl;\
	TO.deriv_axis_cb	= FROM.deriv_axis_cb;\
	TO.deriv_op		= FROM.deriv_op;\
	TO.deriv_func		= FROM.deriv_func;\
	DERIV_COPY(TO.deriv_left,FROM.deriv_left);\
	DERIV_COPY(TO.deriv_rite,FROM.deriv_rite);}
#endif
