COMMENT~

PROGRAM: TTYPE.ASM
 AUTHOR: Denis Boyles

RELEASE: Public Domain (pd) Dec 26, 1996
VERSION: 1.00

COMPILE: Arrowsoft Assembler (MASM v3.0)
     OS: MS-DOS (v6.20)

PURPOSE: a simple teletype program to view text/ansi/etc files.
  NOTES: you'll need ANSI.SYS or another driver to type ansi files.
~

;--------------------------------------
;define some constants for us
;--------------------------------------

LF          EQU 00Ah                   ;define a line feed
CR          EQU 00Dh                   ;define a carriage return
DUL         EQU 024h                   ;define DOS ASCID terminator

PRG SEGMENT
    ASSUME CS:PRG,DS:PRG
    ORG 0100h

MAIN:
    mov     BL,DS:[80h]                ;BL=number of command line chars (PSP)
    or      BL,BL                      ;test for zero character count?
    jz      M2                         ;YES then no filename given, show help

    mov     byte ptr [BX+81h],0        ;YES assume file, NUL terminate it

    mov     AX,3D00h                   ;DOS open file (handle) for normal read
    mov     DX,0082h                   ;DS:DX -> ASCIZ filename to open
    int     21h                        ;call DOS to open given filename

    jc      xMain                      ;was CF set for an error? YES, exit prg

    mov     BX,AX                      ;NO save file handle to BX from AX
    mov     CX,0001h                   ;we're only going to read one byte

M0:                                    ;main read/print loop
    mov     AH,3Fh                     ;DOS read from file handle
    mov     DX,offset buffer           ;DS:DX -> buffer to store data
    int     21h                        ;call DOS to read one character

    or      AX,AX                      ;test for a zero for end of file?
    jz      M1                         ;YES at end of file, so close and quit

    mov     AH,02h                     ;NO DOS print a character
    mov     DL,buffer                  ;character to print is that just read
    int     21h                        ;call DOS to print the character

    jmp     M0                         ;keep looping until end of file

M1:                                    ;end of file
    mov     AH,3Eh                     ;DOS close file handle
    int     21h                        ;call DOS to close the opened file
    jmp     xMain                      ;go exit the program

M2:                                    ;NO filename given, display help
    mov     AH,09h                     ;DOS print an ASCID string
    mov     DX,offset HlpMsg           ;DS:DX -> string to print
    int     21h                        ;call DOS to print help text

xMain:
    ret                                ;a quick exit back to DOS

buffer      db ?
HlpMsg      db CR,LF,"TTYPE [drive:][path]filename[.ext]",CR,LF,DUL

PRG ENDS
END MAIN
