/*
	BANK.H

	29-jun-88, Marc Savary, Ad Lib Inc.
*/

/* structure of timbre bank file: */
typedef
	struct {
		char	majorVersion;
		char	minorVersion;
		unsigned nrTimbre;		/* # of definitions in bank. */
		unsigned	offsetDef;	/* offset in file of first definition */

	 /*	char	timbreName[ ][ TIMBRE_NAME_SIZE];  */
	 /*	int		timbreDef[ ][ TIMBRE_DEF_LEN];  */

	} TimFileBank;

/* structure of descriptor of bank file: */
typedef
	struct {
		int		fileId;
		char	inMemFlag;		/* != 0 if in memory */
		char	modified;
		TimFileBank * timbBank;	/* valid if 'inMemFlag' ... */
	} BankRec;

typedef BankRec * BankPtr;

extern BankPtr OpenBank( /* bankName, createFlag */);
extern int CloseBank( /* bankPtr */);
extern int LoadBank( /* bankPtr */);
extern int GetTimbre( /* timbreName, timbreIndex, timbreDefPtr, bankPtr */);
extern int AddTimbre( /* timbreName, timbIndex, timbreDef, bankPtr */);




