program PlaySample;
{$M $1000, 0, 655360}

{
    (c) Yrj Fager 1993
 This is an example program of FunSound...
}

uses FunSound, Dos;

const ScopeTop = 30;
      VerN = '0.2';                

var FileName : string;
    Rate, I, I2 : integer;
    Convert, Reverse, Scope : boolean;
    SPtr : pointer;
    ScopeCount : byte;
    ScopeA : array [0..255] of byte;

 procedure Abort (AStr : string);
  begin
   WriteLn (AStr);
   HALT;
  end;

 procedure Copyright;
  begin
   WriteLn ('                PlaySample ', VerN);
   WriteLn ('             (C) Yrj Fager 1994 ');
  end;

 procedure Usage;
  begin
   WriteLn (' usage: PS <FILENAME> [RATE] [LPT / SPK] [/R] [/C] [/S]');
   WriteLn ('');
   WriteLn (' LPT will set LPT1 as output device, SPK the internal speaker.');
   WriteLn (' Otherweise, SoundBlaster will be used for sound output.');
   WriteLn ('  /C-parameter converts the sample from Amiga to PC-format');
   WriteLn ('     by XORing it with 128. Very useful when looking inside MODs.');
   WriteLn ('  /R reverses the sample. Find those secret messages...');
   WriteLn ('  /S draws a scope onto VGA/MCGA mode 13h screen.');
   WriteLn ('  /? for more info. ');
   HALT;
  end;

 procedure Info;
  begin
   WriteLn ('  PS demonstrates the use of the new FunSound library.');
   WriteLn (' With PS you can load and play any file that fits in memory.');
   WriteLn ('  FunSound is a unit for Turbo Pascal 6.0, containing many');
   WriteLn (' useful functions for easy sound output.');
   WriteLn ('');
   WriteLn ('  The source code of this program should be included together');
   WriteLn (' with the program itself. (PS.PAS)');
   HALT;
  end;

 procedure SetC (c, r, g, b : byte);
  begin
   Port[$3c8] := c;
   Port[$3c9] := r;
   Port[$3c9] := g;
   Port[$3c9] := b;
  end;

 function UCStr (ucs : string) : string;
  var s : string;
      b : byte;
  begin 
   s := ucs;
   for b := 1 to Length (s) do
    s[b] := UpCase(s[b]);
   UCStr := s;
  end;

 function ValidParam (PNum : byte) : boolean;
  var OldRate : integer;
  begin
   ValidParam := False;
   OldRate := Rate;
   Val (ParamStr(PNum), Rate, I2);
   If I2 = 0 then
    begin
     ValidParam := True;
     fun_SetRate (0, Rate);
    end
   else
    Rate := OldRate;
   If UCStr (ParamStr(PNum)) = 'LPT' then
    begin
     fun_PortType := LPT;
     fun_LPTAddr := fun_GetLPTAddr (1);
     ValidParam := True;
    end;
   If UCStr (ParamStr(PNum)) = 'SPK' then
    begin
     fun_PortType := Speaker;
     ValidParam := True;
    end;
   If (ParamStr(PNum) = '/?') or (ParamStr(PNum) = '?') then
    begin
     Info;
     ValidParam := True;
    end;
   If UCStr (ParamStr(PNum)) = '/C' then
    begin
     Convert := True;
     ValidParam := True;
     Write (' Converting sample from Amiga to PC... ');
     fun_ConvertSample (0);
     WriteLn ('ready.');
    end;
   If UCStr (ParamStr(PNum)) = '/R' then
    begin
     Reverse := True;
     ValidParam := True;
     Write (' Reversing sample...');
     fun_ReverseSequence (SPtr);
     WriteLn ('ready.');
    end;
   If UCStr (ParamStr(PNum)) = '/S' then
    begin
     Scope := True;
     ScopeCount := 0;
     ValidParam := True;
     FillChar (ScopeA, SizeOf(ScopeA), 64+ScopeTop);
    end;
  end;

 procedure UpdateScope;
  var usb : byte;
  begin
   Inc (ScopeCount);
   Mem[$A000:32+ScopeCount+ScopeA[ScopeCount]*320] := 0;
   usb := fun_SampleByte shr 1 + ScopeTop;
   Mem[$A000:32+ScopeCount+usb*320] := usb;
   ScopeA[ScopeCount] := usb;
  end;

begin
 Copyright;
 If ParamCount = 0 then
  Usage;
 If (ParamStr(1) = '/?') or (ParamStr(1) = '?') then Info;
 Rate := 8448;
 fun_LoadLarge (1, ParamStr (1), Rate);
 {This procedure can load larger samples than 64k, but places them
  in separate 64k-blocks.}

 If fun_ErrorStr <> '' then
  Abort (fun_ErrorStr);
 {fun_ErrorStr contains the possible errormessages...}

 SPtr := fun_SeqRange (1, fun_LastLoadedSample);
 {Gets a pointer to the sequence to be used later on.}

 Convert := false; Reverse := false; Scope := False;
 If ParamCount > 1 then
  For I :=  2 to ParamCount do
   begin
    If not ValidParam (I) then
     begin
      WriteLn ('Invalid parameter "',ParamStr(I),'"!');
      HALT;
     end;
   end;

 If (fun_PortType = SBC) and
  (not fun_ResetSBC(100)) then
 If not fun_ResetSBC(100) then
  Abort (' SB not found, a sound player port must be specified.');
 {Searches for a SoundBlaster two times, this is the most reliable way.}

 If Scope then
  begin
   asm
        mov     ax, $13
        int     $10
   end;
   For I := 0 to 63 do
    SetC (I+ScopeTop, 63 - I, I, 47);
   For I := 0 to 63 do
    SetC (I+64+ScopeTop, I, 63 - I, 47);
   WriteLn ('   PlaySample ',VerN,' (c) Yrj Fager 1994');
  end;
 {This initializes the graphics screen.}

 fun_PlaySequence (SPtr);
 {fun_PlaySequence plays a sequence created by the fun_SeqRange-function.}
 Repeat
  If Scope then UpdateScope;
 Until Port[$60] < $80;
 {To get a keystroke}

 {The memory will be released by dos automatically after execution,
  but it can also be made manually with a certain fun_procedure.
  But what we need to do is to restore the original state of the
  timer interrupt, rate and the system clock, so:}

 fun_StopSample;

 If Scope then
  asm
        mov     ax, 3
        int     $10
  end;
end. {PlaySample}
