unit FunSound;

{
                   ͻ
                     F u n S o u n d  
                       
                      (c) Yzi 1994    
                   ͼ

               in co-operation with Marq/Fit

                       version 1.0



   What is FunSound?
   =================

   FunSound is a digitized voice toolkit for Turbo Pascal.
   This file is a complete source of the unit, you have to
   compile it first in order to start using it.


   What FunSound is capable of
   ===========================

   FunSound provides an easy way of playing 8-bit digitized
   voice through SoundBlaster direct mode, SoundBlaster DMA,
   a DA-converter (Covox) in LPT or the internal speaker.


   System Requirements
   ===================

   To use the services of FunSound, you should have an
   IBM-PC compatible computer with Turbo Pascal, version
   6.0 or higher.


   Public Domain
   =============

   FunSound is 100% public domain, you may freely use
   and distribute it, but you are NOT allowed to
   charge any fee for FunSound, or change this package
   in any way.


   Optimization
   ============

   The code in FunSound is only moderately optimized,
   because I wanted it to be safe and easy to develop.
    You could make it faster by doing these things,
   for instance:
       1:  Don't use a procedure when making the interrupt
           handler, or at least leave out the "interrupt"
           and push only the registers you need.
       2:  Change the separate loadings of ES and DI to
           just one LES. You also have to change the order
           of the variables when doing that.
       3:  When checking for the end of the sample, make
           the conditional jumps happen as rarely as
           possible.
       3b: You could also reverse all samples and then
           play them "backwards". This would be very
           fast, because you could DEC the offset all
           the time, and the zero-flag would be set
           automatically at the end...


   The Steps to Play a Sample
   ==========================

   #1: add "FunSound" to the uses-clause of your program
   #2: determine which output method to use.
       Ask the user, for instance. You can also detect,
       what kind of hardware the program is run on. To do
       this, (1) Search for SoundBlaster (fun_ResetSBC)
             (2) Search for available LPT ports (fun_GetLPTAddr)
   #3: if SoundBlaster was chosen, reset it with fun_ResetSBC.
       This will also get the address of the SB.
   #4: load the sample with
        fun_LoadSample, or
        fun_LoadLarge, if the sample is >64kB.
   #5: play it with
        fun_PlaySample, (fun_sbdma_PlaySample) or
        fun_PlaySequence (fun_sbdma_PlaySequence)
   #6: before quitting, stop the output with
        fun_StopSample, (fun_sbdma_StopSample).

   Check out example program PS.PAS to see how the thing is done.
   You should also read all the comments in this file.


   Contacting the Authors
   ======================

   If you encounter any problems with FunSound, or want to
   share your points of view, here's my address:

                  Yrj Fager
                  Vuorenpntie
                  32810 Peipohja
                  Finland

 }

interface

const MaxSamples = 31;
      SequenceSize = 64; {this long sequences are allowed}
      PlokkiSize = 65520; {maximum size of a single block}
       {Sequence codes}
      EndOfSequence = -1; {in the end of a sequence}
      RateDiv = 1193180; {just a number...}

type IsoPlokki = array [0..PlokkiSize-1] of byte;
     SeqPlokki = array [1..SequenceSize] of integer;

var Sample : array [1..MaxSamples] of
{!!Note, that the first sample number is 1 instead of 0!}
      record
       Used : boolean;
       Size,
       LoopE : word;
       Data : ^IsoPlokki;
       Rate : word;
      end;
    LE : word;
    fun_ErrorStr : string;
    fun_PlayInProgress : boolean;

    SampCount : word;
{Includes both the offset of the beginning of the sample, and
 the offset inside the sample. That's why the maximum single
 sample size is 65520 (+ofs(0..15)=0..65535).}

    CurSampNum : integer;
{the number of the sample being currently played}

    SaveInt8 : pointer;

    samp_ofs, samp_seg : word;
{The address of the beginning of the current sample block}

    lastgivencount : word;
{this is for the samplebyte function}

    fun_LoopOn,
    fun_SequenceOn : boolean;
    fun_SequenceCount : word;
    fun_Sequence : ^SeqPlokki;
    fun_CurSample : ^IsoPlokki;

    fun_PortAddr,
{Contains the address of the currently used port (SB or LPT)}

    fun_LPTAddr : word;
    fun_PortType : (Lpt, SBC, Speaker);
{The speaker output has a very low quality due to the low volume,
 and the low dynamics it has. And the output rate should be at
 least 16000Hz, because the playing generates a loud, high sound
 at the output frequency. When the rate is high enough, the beeping
 can not be heard.}

    fun_SB_Addr : word;
{The address of the SB command port (base+$c), for instance $22C}

    fun_LastLoadedSample : integer;
{with this variable you can locate the blocks allocated by a large sample}

    fun_BytesLoaded : longint;
{total bytes loaded in the last load operation}

    PSize : word;

    fun_sbdma_irq,
    fun_sbdma_snum : integer;
    fun_sbdma_curspeed,
    fun_sbdma_curseg,
    fun_sbdma_curofs,
    fun_sbdma_curlen,
    fun_sbdma_nextseg,
    fun_sbdma_nextofs,
    fun_sbdma_bytesleft : word;
    fun_sbdma_oldirqhandler : pointer;
    fun_sbdma_playing : boolean;

procedure waitsb;
{Before sending any commands to SB, you have to wait until it can
 receive them -> use the waitsb often}

function fun_GetLPTAddr (num : word) : word;
{With this function you can detect the addresses of the LPT ports available.

  example: if fun_GetLPTAddr (1) > 0 then
            writeln ('LPT1 is installed.');

       or: fun_PortType := LPT;
           fun_LPTAddr := fun_GetLPTAddr (1);

 Use the number returned when setting the lpt address for sound output.
}

function fun_ResetSBC (Tries : integer) : boolean;
{ Use this to reset the SB. The Tries-variable indicates the number
 of tries to search. Sometimes, not a billion times is enough, after
 execution of certain programs, the SoundBlaster is 'stuck' somehow
 and you have to call the function once more.
  If SB has been found, ResetSBC automatically sets the
 fun_sb_addr-variable.

 example: if not fun_ResetSBC (100) then
           if not fun_ResetSBC (100) then
            writeln ('No blaster, no fun.');

 NOTE: There has been some problems with Gravis UltraSound, when
       detecting the base address. If the SBOS hasn't been loaded,
       fun_ResetSBC may still found it at one of the possible
       addresses. GUS owners should be informed about this.
}

procedure fun_ReleaseSampleMem (SNum : integer);
{This one releases the memory via the SB heap manager. Don't bother
 yourself with this. The memory will be released automatically, when
 you exit the program and if you want to load another sample in the
 same block number, the memory management will be taken care of by
 the load routines.}

procedure fun_AllocSampleMem (SNum : integer; size : word);
{You don't need this either.}

procedure fun_LoadSample (SNum : integer; FileName : string; size, LSrate : word);
{This procedure loads a sample up to 65520 bytes. For larger files use
 the fun_LoadLarge-procedure.}

procedure fun_LoadLarge (SNum : integer; FileName : string; Srate : word);
{With this you can load files as big as the memory can take. Large files
 are divided into smaller sub-blocks, max. 65520B each.}

procedure fun_SetSamplePtr (SNum : integer; SPtr : pointer; Ssize, Srate : word);
{With this procedure you can make a sample by simply pointing somewhere
 in the memory. This is useful, if you link the sample together with
 the exe file, or if you want to do the loading yourself.}

procedure fun_SetRate (SNum : integer; Srate : word);
{Sets the rate of the timer interrupt (int8).}

procedure fun_PlaySample (SNum : integer);
{Plays a sample.}

function fun_SeqRange (s, e : integer) : pointer;
{Generates a sequence containing the numbers s to e and the EOS,
 and gives a pointer to it.
  example: fun_PlaySequence (fun_SeqRange(1, fun_LastLoadedSample)));
}

procedure fun_PlaySequence (SeqPtr : pointer);
{Plays a sequence pointed by SeqPtr. A sequence is a series of
 16-bit signed numbers ("integer"), which indicate the corresponding
 samples. A sequence must end with the End-Of-Sequence (-1).}

procedure fun_StopSample;
{Stops the output and restores the timer interrupt frequency and
 the dos clock.}

procedure fun_ContinueSample;
{Continues a previously stopped sample. No changes in the sample
 parameters may be done before continuing.}

function fun_SampleByte : byte;
{Gives a byte being output "at the moment". For scopes, etc...}

procedure fun_ConvertSample (SNum : integer);
{Converts a sample from Amiga to PC or vice versa. In Amiga samples
 are stored as signed bytes, which makes, by the way, handling them
 easier. Give a zero as the number to convert all samples}

procedure fun_ReverseSample (SNum : integer);
{Reverses a sample. Zero as SNum to do it for all samples.}

procedure fun_ReverseSequence (SeqPtr : pointer);
{Puts the numbers of sequence in reversed order.}

procedure fun_sbdma_PlaySample (SNum : integer);
{This plays a sample through SB dma. Dma uses no cpu time, so
 it doesn't slow down the computer, but it's more difficult to
 follow where the playing goes.}

procedure fun_sbdma_StopSample;
{Stops the dma output.}

procedure fun_sbdma_PlaySequence (SeqPtr : pointer);
{Plays a sequence pointed by SeqPtr.}

function fun_sbdma_setirq (irqnum : word) : boolean;
{Sets the SB dma irq number and returns false, if
 the number is incorrect.}

implementation

 { fun_MemAllocError codes :
     1 - not enough memory }

uses Dos;

var fun_MemAllocError : integer;
    OmaSequence : array [1..MaxSamples+1] of integer;

 procedure Abort (AStr : string);
  begin
   WriteLn (AStr);
   HALT;
  end; {Abort}

 procedure SetInt8Rate (D : word);
  assembler;
  asm
        mov   ax, d
        out   $40, al
        shr   ax, 8
        out   $40, al
        sub   al, al
        out   $43, al
  end; {SetInt8Rate}

 procedure waitsb;
  assembler;
  asm
        mov     dx, fun_SB_Addr
@venttaus:
	in      al,dx
	test    al,080h
	jnz     @venttaus
  end;

 procedure SpeakerOn;
  begin
   Case fun_PortType of 
    SBC : Port[fun_SB_Addr] := $D1;
    Speaker : Port[$61] := 3;
   end;
  end;

 procedure SpeakerOff;
  begin
   Case fun_PortType of
    SBC : Port[fun_SB_Addr] := $D3;
    Speaker : Port[$61] := Port[$61] and 252;
   end;
  end;

 function fun_GetLPTAddr (num : word) : word;
  begin
   fun_getlptaddr :=
    mem[$40:6+num shl 1] +
    mem[$40:7+num shl 1] shl 8;
  end; {get_lpt_addr}

 procedure SetNormal;
  begin
   asm
        mov     ah, 2           {get correct time from RTC}
        int     $1a             {int 1a, 2}
        sub     ah, ah          {returns time as ch:cl:dh BCD}
        mov     bl, 10          {the BCD numbers have to be}
        mov     al, ch          {converted before passing to}
        shr     al, 4           {the dos service}
        mul     bl
        and     ch, $f
        add     al, ch
        mov     ch, al
        mov     al, cl
        shr     al, 4
        mul     bl
        and     cl, $f
        add     al, cl
        mov     cl, al
        mov     al, dh
        shr     al, 4
        mul     bl
        and     dh, $f
        add     al, dh
        mov     dh, al
        sub     dl, dl
        mov     ah, $2d         {int 21, 2d: set time (ch:cl:dh:dl)}
        int     $21
   end;
   SetIntVec (8, SaveInt8);
   SetInt8Rate (65535);
   SpeakerOff;
  end; {SetNormal}

 procedure SetNextBlock;
  begin
   If not fun_SequenceOn then
    begin
     If fun_LoopOn then
      SampCount := samp_ofs
     else SetNormal;
    end
   else
    begin
     asm
	mov     SampCount, 0
	inc     fun_SequenceCount
     end;
     If fun_Sequence^[fun_SequenceCount] = EndOfSequence then
      If fun_LoopOn then
       fun_SequenceCount := 1
      else SetNormal;
     If fun_PlayInProgress then
      begin
       CurSampNum := fun_Sequence^[fun_SequenceCount];
       fun_CurSample := Addr(Sample[CurSampNum].Data^);
       LE := Sample[fun_Sequence^[fun_SequenceCount]].LoopE;
      end;
    end;
   samp_seg := seg(fun_CurSample^);
   samp_ofs := ofs(fun_CurSample^);
   Inc (LE, samp_ofs);
   asm
        mov     di, sampcount
   end;
  end;

 procedure PlayInt;
  interrupt;
  begin
   asm
	inc     SampCount
	mov     ax, LE
	mov     di, SampCount
	cmp     di, ax
	jb      @ohi
	call    SetNextBlock
@ohi:                   
	mov     dx, fun_SB_Addr
@eka:     
	in      al,dx
	test    al,080h
	jnz     @eka
	mov     al, $10
	out     dx, al
@toka:     
	in      al,dx
	test    al,080h
	jnz     @toka
	mov     ax, samp_seg
	mov     es, ax
	mov     al, es:[di]
	out     dx, al
	mov     al, $20
	out     $20, al
   end;
  end; {PlayInt}

 procedure PlayLPTInt;
  interrupt;
  begin
   asm
	inc     SampCount
	mov     di, SampCount
	mov     ax, LE
	cmp     di, ax
	jb      @ohi
	call    SetNextBlock
@ohi:
	mov     dx, fun_PortAddr
	mov     ax, samp_seg
	mov     es, ax
	mov     al, es:[di]
	out     dx, al
	mov     al, $20
	out     $20, al
   end;
  end; {PlayLPTInt}

 procedure PlaySpeakerInt;
  interrupt;
  begin
   asm
	inc     SampCount
	mov     di, SampCount
	mov     ax, LE
	cmp     di, ax
	jb      @ohi
	call    SetNextBlock
@ohi:
	mov     ax, samp_seg
	mov     es, ax
	mov     al, es:[di]
        shr     al, 1                   {change this if you don't like it}
	out     $42, al
	mov     al, $20
	out     $20, al
   end;
  end; {PlaySpeakerInt}

 procedure SetPlaying;
  begin
   SetInt8Rate (RateDiv div Sample[CurSampNum].Rate);
   Case fun_PortType of
    SBC :
     begin
      SetIntVec (8, @PlayInt);
     end;
    LPT :
     begin
      fun_PortAddr := fun_LptAddr;
      SetIntVec (8, @PlayLPTInt);
     end;
    Speaker :
     begin
      Port[$43] := 128+16+1;
      fun_PortAddr := $FFFF;
      SetIntVec (8, @PlaySpeakerInt);
     end;
   end; {Case}
   SpeakerOn;
  end; {SetPlaying}

function fun_ResetSBC (Tries : integer) : boolean;
 var Luku : word;
     i : integer;
     Okei : boolean;
     Found : boolean;
 begin
  fun_ResetSBC := False;
  Found := False;
  Luku := $210;
  Repeat
   Okei := False;
   i := 0;
   Repeat
    Inc (i);
    Port[Luku+6] := 1;
    Repeat Until Port[$3DA] and 1 = 0;
    Repeat Until Port[$3DA] and 1 = 1;
    Port[Luku+6] := 0;
    If Port[Luku+$A]=$AA then
     begin
      Okei := True;
      Found := true;
      fun_SB_Addr := Luku+$C;
     end;
   Until Okei or (i = Tries);
   Inc (Luku, $10);
  Until (Luku = $270) or Found;
  If Not Found then fun_ResetSBC := false
   else fun_ResetSBC := true;
 end; {fun_ResetSBC}

procedure fun_ReleaseSampleMem (SNum : integer);
 var I : integer;
 begin
  If SNum = 0 then
   begin
    For I := 1 to MaxSamples do
     If Sample[I].Used then
      FreeMem (Sample[SNum].Data, Sample[SNum].Size);
    EXIT;
   end;
  If (not Sample[SNum].Used) or
     (SNum < 0) or (SNum > MaxSamples) then EXIT;
  FreeMem (Sample[SNum].Data, Sample[SNum].Size);
 end; {fun_ReleaseSampleMem}

procedure fun_AllocSampleMem (SNum : integer; size : word);
 begin
  fun_MemAllocError := 0;
  If Sample[SNum].Used then
   fun_ReleaseSampleMem (SNum);
  If MaxAvail < size then
   begin
    fun_MemAllocError := 1;
    EXIT;
   end;
  GetMem (Sample[SNum].Data, size);
  Sample[SNum].Used := True;
 end; {fun_AllocSampleMem}

procedure fun_LoadSample (SNum : integer; FileName : string; size, LSrate : word);
 var Faili : file;
     SampleLength : word;
     fsiz : longint;
 begin
  DosError := 0;
  fun_ErrorStr := '';
  Assign (Faili, FileName);
  {$I-}
  Reset (Faili, 1);
  If IOResult <> 0 then
   begin
    fun_ErrorStr :=
     'Cannot find/open file '+FileName+'!';
    EXIT;
   end;
  fsiz := FileSize (faili);
  If fsiz <= PlokkiSize then
   SampleLength := fsiz
  else
   SampleLength := PlokkiSize;
  If (size < SampleLength) and (size > 0) then
   SampleLength := size;
  fun_AllocSampleMem (SNum, SampleLength);
  if fun_MemAllocError <> 0 then
   begin
    fun_ErrorStr :=
     'MemAllocError: Cannot allocate memory for '+FileName;
    EXIT;
   end;
  BlockRead (Faili, Sample[SNum].Data^, SampleLength);
  Sample[SNum].Size := SampleLength;
  Sample[SNum].Rate := LSrate;
  Sample[Snum].LoopE := SampleLength - 1;
  If IOResult <> 0 then
   begin
    fun_ErrorStr :=
     'Error loading '+FileName;
    EXIT;
   end;
  Close (Faili);
 end; {fun_LoadSample}

procedure fun_LoadLarge (SNum : integer; FileName : string; Srate : word);
 var Faili : file;
     SCount : integer;
     SSize, BytesLeft : longint;
 begin
  fun_ErrorStr := '';
  {$I-}
  Assign (Faili, FileName);
  Reset (Faili, 1);
  If IOResult <> 0 then
   begin
    fun_ErrorStr := 'Cannot find/open file '+FileName+'!';
    EXIT;
   end;
  SSize := FileSize (Faili);
  If SSize > MemAvail then
   begin
    fun_ErrorStr := 'Not enough memory for '+FileName+'!';
    EXIT;
   end;
  BytesLeft := SSize;
  SCount := SNum;
  Repeat
   If BytesLeft <= PSize then
    begin
     fun_AllocSampleMem (SCount, BytesLeft);
     If fun_MemAllocError <> 0 then
      begin
       fun_ErrorStr := 'Cannot get memory for '+FileName+'!';
       EXIT;
      end;
     BlockRead (Faili, Sample[SCount].Data^, BytesLeft);
     Sample[SCount].Size := BytesLeft;
     Sample[SCount].Rate := Srate;
     Sample[SCount].LoopE := BytesLeft-1;
     BytesLeft := 0;
    end
   else
    begin
     fun_AllocSampleMem (SCount, PSize);
     If fun_MemAllocError <> 0 then
      begin
       fun_ErrorStr := 'Cannot get memory for '+FileName+'!';
       EXIT;
      end;
     BlockRead (Faili, Sample[SCount].Data^, PSize);
     Sample[SCount].Size := PSize;
     Sample[SCount].Rate := Srate;
     Sample[SCount].LoopE := PSize-1;
     Inc (SCount);
     Dec (BytesLeft, PSize);
    end;
  Until BytesLeft <= 0;
  Close (Faili);
  fun_LastLoadedSample := SCount;
  fun_BytesLoaded := SSize;
 end; {fun_LoadLarge}

procedure fun_SetSamplePtr (SNum : integer; SPtr : pointer; Ssize, Srate : word);
 begin
  With Sample[SNum] do
   begin
    rate := Srate;
    size := Ssize;
    LoopE := Ssize-1;
    Data := SPtr;
    Used := true;
   end;
 end; {fun_SetSamplePtr}

procedure fun_SetRate (SNum : integer; Srate : word);
 var sri : integer;
 procedure SetIt (Nummero : integer);
  begin
   Sample[Nummero].rate := Srate;
  end;
 begin
  If SNum = 0 then  
   begin
    For sri := 1 to MaxSamples do
     SetIt(sri);
   end
  else
   If (SNum > 0) and (SNum <= MaxSamples) then
    SetIt(SNum);
 end; {fun_SetRate}

procedure fun_PlaySample (SNum : integer);
 begin
  If not Sample[SNum].Used then EXIT;
  CurSampNum := SNum;
  LE := Sample[SNum].LoopE;
  fun_CurSample := Addr(Sample[SNum].Data^);
  samp_seg := seg(fun_CurSample^);
  samp_ofs := ofs(fun_CurSample^);
  SampCount := samp_ofs;
  SetPlaying;
  fun_PlayInProgress := true;
 end; {fun_PlaySample}

function fun_SeqRange (s, e : integer) : pointer;
 var I, I2 : integer;
 begin
  If (s > e) or (e > MaxSamples) then
   begin
    Abort ('Invalid call to fun_SeqRange.');
   end;
  I2 := 1;
  For I := s to e do
   begin
    OmaSequence[I2] := I;
    Inc (I2);
   end;
  OmaSequence[I2] := EndOfSequence;
  fun_SeqRange := Addr(OmaSequence);
 end; {fun_SeqRange}

procedure fun_PlaySequence (SeqPtr : pointer);
 begin
  SetNormal;
  fun_Sequence := SeqPtr;
  fun_SequenceCount := 1;
  fun_SequenceOn := true;
  fun_PlaySample (fun_Sequence^[1]);
 end; {fun_PlaySequence}

procedure fun_StopSample;
 begin
  SetNormal;
  fun_PlayInProgress := false;
 end; {fun_StopSample}

procedure fun_ContinueSample;
 begin
  SetPlaying;
  fun_PlayInProgress := true;
 end; {fun_ContinueSample}

function fun_SampleByte;
 begin
  If not fun_PlayInProgress then
   begin
    fun_SampleByte := 128;
    EXIT;
   end;
  Repeat
  Until SampCount <> lastgivencount;
  lastgivencount := SampCount;
  fun_SampleByte := Mem[samp_seg:SampCount];
 end;  {fun_SampleByte}

procedure fun_ConvertSample (SNum : integer);
 var csi : integer;
 procedure Convert (sn : integer);
  var cseg, cofs, clen : word;
  begin
   If not Sample[sn].Used then EXIT;
   cseg := seg (Sample[sn].Data^);
   cofs := ofs (Sample[sn].Data^);
   clen := Sample[sn].Size;
   asm
	mov     ax, cseg    
	mov     es, ax
	mov     di, cofs
	mov     bx, di
	add     bx, clen
@looppi:
	xor     byte ptr [es:di], 128
	inc     di
	cmp     di, bx
	jb      @looppi
   end;
  end; {Convert}
 begin
  fun_ErrorStr := '';
  If (SNum > MaxSamples) or (SNum < 0) then
   begin
    fun_ErrorStr := 'Invalid sample number to be converted.';
    EXIT;
   end;
  If SNum = 0 then  
   begin
    For csi := 1 to MaxSamples do
     Convert (csi);
   end
  else Convert (SNum);
 end; {fun_ConvertSample}

procedure fun_ReverseSample (SNum : integer);
 var rsi : integer;
 procedure Reverse (sn : integer);
  var rseg, rofs, rlen, saveDS, saveDI : word;
  begin
   If not Sample[sn].Used then EXIT;
   rseg := seg (Sample[sn].Data^);
   rofs := ofs (Sample[sn].Data^);
   rlen := Sample[sn].Size;
   asm
	push    ds
	mov     ax, rseg
	mov     es, rseg
	mov     di, rofs
	mov     ds, ax
	mov     si, di
	add     si, rlen
	dec     si        
	mov     bx, rlen
	shr     bx, 1
@looppi:
	mov     al, byte ptr [ds:si]
	mov     ah, byte ptr [es:di]
	mov     byte ptr [es:di], al
	mov     byte ptr [ds:si], ah
	dec     si
	inc     di
	dec     bx
	test    bx, $ffff
	jnz     @looppi

        pop     ds
   end;
  end;
 begin
  fun_ErrorStr := '';
  If (SNum > MaxSamples) or (SNum < 0) then
   begin
    fun_ErrorStr := 'Invalid sample number to be reversed.';
    EXIT;
   end;
  If SNum = 0 then  
   begin
    For rsi := 1 to MaxSamples do
     Reverse (rsi);
   end
  else Reverse (SNum);
 end;

procedure fun_ReverseSequence (SeqPtr : pointer);
 var Seqqi : ^SeqPlokki;
     Counter, rsw : word;
     rsi : integer;
     Reversed : array [1..MaxSamples] of boolean;
 begin
  fun_ErrorStr := '';
  Seqqi := SeqPtr;
  For rsi := 1 to MaxSamples do Reversed[rsi] := false;
  Counter := 0;
  Repeat
   Inc (Counter);
  Until (Counter > SequenceSize) or (Seqqi^[Counter]=EndOfSequence);
  If Counter > SequenceSize then
   begin
    fun_ErrorStr := '(fun_ReverseSequence:) Sequence too long! Invalid pointer???';
    EXIT;
   end;
  For rsi := 1 to (Counter) div 2 do
   begin                    
    rsw := Seqqi^[rsi];
    Seqqi^[rsi] := Seqqi^[counter-rsi];
    Seqqi^[counter-rsi] := rsw;    
   end;    
  For rsi := 1 to Counter - 1 do
   begin
    If not Reversed[Seqqi^[rsi]] then
     begin
      fun_ReverseSample (Seqqi^[rsi]);
      If fun_ErrorStr <> '' then
       EXIT;
     end;
    Reversed[Seqqi^[rsi]] := true;
   end;
 end; {fun_ReverseSequence}

{
    ------------------------ SB DMA PART ------------------------
}

 procedure setDMAaddress (dmapage, dmaoffset : word);
  begin
   port[$02] := byte(dmaoffset and $ff);
   port[$02] := byte(dmaoffset shr 8);
   port[$83] := dmapage shr 12;
  end; {setDMAaddress}

 procedure setDMAspeed (speed : word);
  var apu : byte;
  begin
   apu := 256 - longint(1000000 div speed);
   waitsb;
   port[fun_SB_addr] := $40;
   waitsb;
   port[fun_SB_addr] := apu;
  end; {setDMAspeed}

 procedure setDMAlength (dmalen : word);
  begin
   port[$03] := byte((dmalen - 1) and $ff);
   port[$03] := byte((dmalen - 1) shr 8);
  end; {setDMAlength}

 procedure setDSPlength (dsplen : word);
  begin
   waitsb;
   port[fun_SB_addr] := $14;
   waitsb;
   port[fun_SB_addr] := byte((dsplen - 1) and $ff);
   waitsb;
   port[fun_SB_addr] := byte((dsplen - 1) shr 8);
  end;

 procedure PlayIt (SNum : integer);
   var b : byte;
      maxdmalen,
      curs, curo : word;
      l : word;
  begin
      {Let's tell dsp 'boud tha dma}
   b := port[fun_SB_addr + 2]; {base + $e}
    {mask out ch. 1}
   port[$0a] := 5;
    {reset dma counter}
   port[$0c] := 0;
    {dma mode: memory->sb}
   port[$0b] := $49;

   curs := seg(Sample[SNum].Data^);
   curo := ofs(Sample[SNum].Data^);
    {calculate 20-bit address for the sample and to the next physical
     segment start}
   l := curs and $0fff;
   inc (curo, l shl 4);
   curs := curs and $f000;
   maxdmalen := (65535 - curo) + 1;
   If (Sample[SNum].LoopE > maxdmalen) then
    begin
     fun_sbdma_curlen := maxdmalen;
     fun_sbdma_bytesleft := Sample[SNum].LoopE - maxdmalen;
     fun_sbdma_nextseg := curs + $1000;
     fun_sbdma_nextofs := 0;
    end
   else
    begin
     fun_sbdma_curlen := Sample[SNum].LoopE;
     fun_sbdma_bytesleft := 0;
    end;
   fun_sbdma_curseg := curs;
   fun_sbdma_curofs := curo;
   setDMAaddress (curs, curo);
   setDMAlength (fun_sbdma_curlen);

    {set dma transfer on}
   port[$0a] := 1;
    {now dma waits for dsp to start the transfer}
   fun_sbdma_curspeed := Sample[SNum].Rate;
   setDMAspeed (fun_sbdma_curspeed);
   setDSPlength (fun_sbdma_curlen);
  end; {PlayIt}

 procedure fun_sbdma_StopSample;
  begin
   port[fun_sb_addr] := $d3;
   port[$21] := port[$21] or (1 shl fun_sbdma_irq);
   SetIntVec (8 + fun_sbdma_irq, fun_sbdma_oldirqhandler);
   port[$0a] := 5; {mask out ch. 1}
   fun_sbdma_playing := false;
  end;

 procedure fun_sbdma_irqhandler;
  interrupt;
  var b : byte;
      maxdmalen,
      curs, curo : word;
      l : word;
      lee : word;
  begin
   If fun_sbdma_bytesleft > 0 then
    begin
     fun_sbdma_curlen := fun_sbdma_bytesleft;
     fun_sbdma_bytesleft := 0;
     fun_sbdma_curseg := fun_sbdma_nextseg;
     fun_sbdma_curofs := fun_sbdma_nextofs;
     b := port[fun_SB_addr + 2]; {base + $e}
      {mask out ch. 1}
     port[$0a] := 5;
      {reset dma counter}
     port[$0c] := 0;
      {dma mode: muisti->sb}
     port[$0b] := $49;
     setDMAaddress (fun_sbdma_curseg, fun_sbdma_curofs);
     setDMAlength (fun_sbdma_curlen);
      {set dma transfer on}
     port[$0a] := 1;
      {now dma waits for dsp to start the transfer}
     setDMAspeed (fun_sbdma_curspeed);
     setDSPlength (fun_sbdma_curlen);
    end
   else
    begin
     If fun_SequenceOn then
      begin
       asm
	mov     SampCount, 0
	inc     fun_SequenceCount
       end;
       If fun_Sequence^[fun_SequenceCount] = EndOfSequence then
        begin
         If fun_LoopOn then
          begin
           fun_SequenceCount := 1;
           fun_sbdma_snum := fun_Sequence^[fun_SequenceCount];
           PlayIt (fun_sbdma_snum);
          end
         else fun_sbdma_StopSample;
        end {if seq. at end}
       else
        begin {seq. ei lopussa}
         fun_sbdma_snum := fun_Sequence^[fun_SequenceCount];
         PlayIt (fun_sbdma_snum);
        end;
      end
     else
      begin
       If fun_LoopOn then
        PlayIt (fun_sbdma_snum)
       else
        fun_sbdma_StopSample;
      end;
    end; {jos SetNextBlock}
   port[$20] := $20; {end-of-interrupt}
  end;

 procedure fun_sbdma_PlaySample (SNum : integer);
  begin
   If (SNum < 1) or (SNum > MaxSamples) then EXIT;
   If (not Sample[SNum].Used) then EXIT;
   If (Sample[SNum].LoopE < 2) then EXIT;
   fun_sbdma_snum := SNum;

   waitsb;
   port[fun_sb_addr] := $d1; {kajari auki}
   GetIntVec (8 + fun_sbdma_irq, fun_sbdma_oldirqhandler);

   PlayIt (SNum);

   SetIntVec (8 + fun_sbdma_irq, @fun_sbdma_irqhandler);
   port[$21] := port[$21] and ($ff-(1 shl fun_sbdma_irq));

   fun_sbdma_playing := true;
  end; {fun_sbdma_PlaySample}

 procedure fun_sbdma_PlaySequence (SeqPtr : pointer);
  begin
   If fun_PlayInProgress then
    SetNormal;
   If fun_sbdma_playing then
    fun_sbdma_StopSample;
   fun_Sequence := SeqPtr;
   fun_SequenceCount := 1;
   fun_SequenceOn := true;
   fun_sbdma_PlaySample (fun_Sequence^[1]);
  end; {fun_sbdma_PlaySequence}

 function fun_sbdma_setirq (irqnum : word) : boolean;
  begin
   If (irqnum < 2) or (irqnum > 7) or (irqnum = 4) or (irqnum = 6) then
    begin
     fun_ErrorStr := 'fun_sbdma_setirq: invalid irq (use 2,3,5,7)';
     fun_sbdma_setirq := false;
     EXIT;
    end;
   fun_sbdma_irq := irqnum;
   fun_sbdma_setirq := true;
  end; {fun_sbdma_setirq}

var I : integer;
begin
 For I := 1 to MaxSamples do
  With Sample[I] do
   begin
    Used := false;
    Size := 0;
    Rate := 8000;
    LoopE := 0;
   end;
 LE := 0;
 SampCount := 0;
 CurSampNum := 1;
 fun_ErrorStr := '';
 fun_PlayInProgress := false;
 fun_LoopOn := true;
 fun_SequenceCount := 1;
 fun_SequenceOn := false;
 fun_PortAddr := $22C;
 fun_PortType := SBC;
 fun_LPTAddr := $3BC;
 fun_SB_Addr := $22C;
 fun_LastLoadedSample := 0;
 fun_BytesLoaded := 0;

 fun_sbdma_playing := false;
 fun_sbdma_irq := 7;

 PSize := PlokkiSize;
 GetIntVec (8, SaveInt8);
end. {FunSound}
