/* ***********************************************************************
   *									 *
   *			Recursive Triangle Generator			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *				Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "math.inc"
#include "graph.inc"

#define Ang1 0
#define Ang2 120
#define Ang3 240

int X1, Y1, X2, Y2, X3, Y3;
int Level, Xc, Yc;
int Col;

void Triangle(int X1, int Y1, int X2, int Y2, int X3, int Y3, int Level)
{
  int Xp1, Xp2, Xp3;
  int Yp1, Yp2, Yp3;

  if(Level==0)
  {
    Xp1=Xc+X1;
    Yp1=Yc-Y1;
    Xp2=Xc+X2;
    Yp2=Yc-Y2;
    Xp3=Xc+X3;
    Yp3=Yc-Y3;
    Draw(Xp1, Yp1, Xp2, Yp2, Col);
    Draw(Xp2, Yp2, Xp3, Yp3, Col);
    Draw(Xp3, Yp3, Xp1, Yp1, Col);
  }
  else
  {
    Triangle(X1, Y1, (X1+X2) / 2, (Y1+Y2) / 2, (X1+X3) / 2, (Y1+Y3) / 2, Level-1);
    Triangle(X2, Y2, (X2+X3) / 2, (Y2+Y3) / 2, (X2+X1) / 2, (Y2+Y1) / 2, Level-1);
    Triangle(X3, Y3, (X3+X1) / 2, (Y3+Y1) / 2, (X3+X2) / 2, (Y3+Y2) / 2, Level-1);
    Col=Level*36+35;
  }
}

void main()
{
  Title();
  Level=0;
  puts("Recursive Triangle Generator");
  puts("");
  printf("Level (1-7) => ");
  scanf("%d", &Level);
  InitGraphics();
  Col=35;
  Xc=160;
  Yc=100;
  X1=Round(Xc*CosD(Ang1));
  Y1=Round(Yc*SinD(Ang1));
  X2=Round(Xc*CosD(Ang2));
  Y2=Round(Yc*SinD(Ang2));
  X3=Round(Xc*CosD(Ang3));
  Y3=Round(Yc*SinD(Ang3));
  Triangle(X1, Y1, X2, Y2, X3, Y3, Level);
  ExitGraphics();
}

