//*****************************************************************
//
//  VESA library include file
//
//*****************************************************************

// Data structure for VESA function 4F00h ( Get VBE Information )
//

struct vesa_infoblock { 
  byte   VbeSignature;       // VBE Signature
  word   VbeVersion;         // VBE Version
  dword  OemStringPtr;       // Pointer to OEM String
  dword  Capabilities;       // Capabilities of graphics cont.
  dword  VideoModePtr;       // Pointer to Video Mode List
  word   TotalMemory;        // Number of 64kb memory blocks
// Added for VBE 2.0
  word   OemSoftwareRev;     // VBE implementation Software revision
  dword  OemVendorNamePtr;   // Pointer to Vendor Name String
  dword  OemProductNamePtr;  // Pointer to Product Name String
  dword  OemProductRevPtr;   // Pointer to Product Revision String
  byte   _Reserved_[222];    // Reserved for VBE implementation
                                     // scratch area
  byte   OemData[256];      // Data Area for OEM Strings
};


// Data structure for VESA function 4F01h ( Get mode Information )
//
struct vesa_modeinfoblock {
  // Mandatory information for all VBE revisions
  word   ModeAttributes;     // mode attributes
  byte   WinAAttributes;     // window A attributes
  byte   WinBAttributes;     // window B attributes
  word   WinGranularity;     // window granularity
  word   WinSize;            // window size
  word   WinASegment;        // window A start segment
  word   WinBSegment;        // window B start segment
  dword  WinFuncPtr;         // pointer to window function
  word   BytesPerScanLine;   // bytes per scan line

  // Mandatory information for VBE 1.2 and above
  word   XResolution;        // horizontal resolution in pixels or chars
  word   YResolution;        // vertical resolution in pixels or chars
  byte   XCharSize;          // character cell width in pixels
  byte   YCharSize;          // character cell height in pixels
  byte   NumberOfPlanes;     // number of memory planes
  byte   BitsPerPixel;       // bits per pixel
  byte   NumberOfBanks;      // number of banks
  byte   MemoryModel;        // memory model type
  byte   BankSize;           // bank size in KB
  byte   NumberOfImagePages; // number of images
  byte   _Reserved;          // reserved for page function

  // Direct Color fields (required for direct/6 and YUV/7 memory models)
  byte   RedMaskSize;        // size of direct color red mask in bits
  byte   RedFieldPosition;   // bit position of lsb of red mask
  byte   GreenMaskSize;      // size of direct color green mask in bits
  byte   GreenFieldPosition; // bit position of lsb of green mask
  byte   BlueMaskSize;       // size of direct color blue mask in bits
  byte   BlueFieldPosition;  // bit position of lsb of blue mask
  byte   RsvdMaskSize;       // size of direct color reserved mask in bits
  byte   RsvdFieldPosition;  // bit position of lsb of reserved mask
  byte   DirectColorModeInfo;// direct color mode attributes

  // Mandatory information for VBE 2.0 and above
  dword  PhysBasePtr;        // physical address for flat frame buffer
  dword  OffScreenMemOffset; // pointer to start of off screen memory
  word   OffScreenMemSize;   // amount of off screen memory in 1k units
  byte   __Reserved[206];    // remainder of ModeInfoBlock
};


