/*  STOI.C   More powerful version of atoi.
 *   from DDJ May 1985.  Copyright Allen Holub.
 */

#define islower(c)     ( 'a' <= (c) && (c) <= 'z' )
#define toupper(c)     ( islower(c) ? (c) - 0x20 : (c) )

/* ---- stoi:  Converts string to integer.  If string starts with 0x, it is
 *        interpreted as a hex number, else if it starts with a 0, it is
 *        octal, else it is decimal.  Conversion stops on encountering the
 *        first character which is not a digit in the indicated radix.
 *        *instr is updated to point past the end of the number.
 */
int    stoi(instr)
  register char **instr;
{
  register int  num = 0;
  register char *str;
  int           sign = 1;

  str = *instr;

  while ( *str == ' ' || *str == '\t' || *str == '\n')
    str++;

  if (*str == '-' )
  {
    sign = -1;
    str++;
  }

  if (*str == '0')
  {
    ++str;
    if (*str == 'x' || *str == 'X')
    {
      str++;
      while ( ( '0' <= *str && *str <= '9') ||
              ( 'a' <= *str && *str <= 'f') ||
              ( 'A' <= *str && *str <= 'F')   )
      {
        num *= 16;
        num += ('0' <= *str && *str <= '9') ? *str - '0'
                                            : toupper(*str) - 'A' + 10 ;
        str++;
      }
    }
    else      /* handle octal */
    {
      while ( '0' <= *str && *str <= '7')
      {
        num *= 8;
        num += *str++ - '0';
      }
    }
  }
  else  /* handle decimal */
  {
    while ( '0' <= *str && *str <= '9')
    {
      num *= 10;
      num += *str++ - '0';
    }
  }
  *instr = str;
  return (num * sign);
}


