/*  CTERM.H   defines for CTERMx series. */

#define BUFSIZE     128
#define DISKREAD    (BUFSIZE * 40)

/* some ASCII defines */
#define SOH         0x01        /* start of header */
#define EOT         0x04        /* end of transmission */
#define ACK         0x06        /* positive acknowledgement */
#define BS          0x08        /* backspace */
#define CR          0x0D        /* Carriage Return */
#define NAK         0x15        /* Negative acknowledgement */
#define CAN         0x18        /* Cancel */
#define EoF         0x1A        /* End of File (used for name) */
#define ESC         0x1B        /* ASCII escape key */
#define CRC         0x43        /* ASCII 'C' (CRC mode request) */
#define BADNAME     0x75        /* Received bad name checksum */
#define TIMEOUT     -1          /* for state machine logic */

static char *SPEED_LIST[] =
 {   "50",   "75",  "110",  "135",  "150",  "300",  "600",  "1200",
   "1800", "2000", "2400", "3600", "4800", "7200", "9600", "19200",
   "28800", "38400", "57600" };

static int SPEED_VALS[] =
 {   50,   75,  110,  135,  150,  300,  600,  1200,
   1800, 2000, 2400, 3600, 4800, 7200, 9600, 19200,
   28800, 38400, 57600,  0 };  /* zero for anchor */

static char *PARITY_LIST[] =
 { "NONE", "NONE", "ODD", "EVEN", };    /* matches L_CTRL p_enable + p_even */

static char *STOP_LIST[] =
 { "ONE", "TWO" };                      /* matches L_CTRL p_two_stops */

static char *BITS_LIST[] =
 { "FIVE", "SIX", "SEVEN", "EIGHT" };

/* Define some common values for the lctrl bit fields */
#define ate1none   0x03;
#define sev1even   0x1A;

typedef int (*action)();      /* action is a pointer to a function */

struct event_entry {
   char comment[20];      /* for commented reading and tracing capability */
   action act;            /* pointer to action function */
   int param;             /* parameter to pass to function */
   enum send_state next_state;  /* from an enumerated list of states */
  };

/* The following enumeration is used in all modules */
enum modes { M_Cmd, M_Term, M_Config, M_XSend, M_XRecv };

/* This struct maps the data packets for the protocol */
typedef struct pkt {
  unsigned char soh;
  unsigned char pkt;
  unsigned char pkt_cmp;
  unsigned char data[BUFSIZE];
  unsigned char crc1;
  unsigned char crc2;
} XPKT;

/*  Defines used for keyfun(). - Map exactly to BIOS intr 16h 0 and 1 */
#define KEYHIT     1
#define READNEXT   0
#define BIOS_KEY 0x16        /* for int86 call for keyboard interrupt */

/* The following defines are used to map scan codes for f keys and specials */
#define HOME 0x4700
#define PGUP 0x4900
#define END  0x4F00
#define PGDN 0x5100
#define INS  0x5200
#define DEL  0x5300
#define CBRK 0x0000      /* Book says 0x5400.  I see 0x0000 */
