#define PORT  2              /* currently a define 12/16/88 */
#define NAMESIZE   24        /* Used by xmsend and recv */
#define TXTRIES     5        /* Transmit retries */
#define RXTRIES    10        /* Receive retries */

/* Parameters to pass to Send Action Make_Pkt and Recv Action Frame_Wait */
#define RESEND      0
#define INIT        1
#define NEXT        2

/*  The following declaration is used to pass config info to Config_Comm().  */
typedef struct {     /* Map to UART Line Control bits */
        unsigned wlen      : 2;       /* Word length - 5 */
        unsigned two_stops : 1;       /* 1: Two stops,   0: One stop */
        unsigned parity    : 2;       /* 00, 01: NONE, 10 ODD, 11 EVEN */
        unsigned p_stuck   : 1;       /* 1: Stuck,       0: Normal */
        unsigned set_break : 1;       /* 1: Send break   0: Stop break */
        unsigned div_latch : 1;       /* 1: See divisors 0: See data bytes */
        unsigned           : 8;
      } L_CTRL;

  typedef union {
        unsigned char lctrl;
        L_CTRL lbits;
      } U_BITS;

  typedef struct
    {
      unsigned speed;       /* value from atoi() of value from speed array */
      U_BITS ubits;
    } S_INIT;

