/*
  ͻ
                                                                          
                                  Engine                                  
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ

  not modeled after an actual engine - just for show
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define Pi_Over_180 0.01745

float SinD(float a)
{
  return(sin(a*Pi_Over_180));
}

float CosD(float a)
{
  return(cos(a*Pi_Over_180));
}

typedef char name[13];

FILE *textdiskfile;
name filename;

Word xresolution=160;
Word yresolution=100;
Byte numberofframes=30;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                                Engine                                  \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    2\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.600\n");
  fprintf(textdiskfile,"   OBSPOS  =  462.000 -660.000  270.000\n");
  fprintf(textdiskfile,"   ROTATE  =  -36.000\n");
  fprintf(textdiskfile,"   TILT    =   11.500\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PLASTICTILE\n");
  fprintf(textdiskfile,"   TEXTURE = CHECKER\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    8.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(textdiskfile,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TILE    =    0.012\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = STEEL\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.650    0.650    0.650\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.150    0.150    0.150\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   25.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = PLASTICTILE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  350.000 -350.000  380.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.250    0.250    0.210\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     = -350.000 -350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
}

void make()
{
  Byte frame;
  float phase;
  float xp, zp;

  phase=0.0;
  for(frame=1; frame<=numberofframes; frame++)
  {
    writestudio();

	  /*  Main Shaft  */

    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC =   0.000 -130.000  75.000\n");
    fprintf(textdiskfile,"   RADIUS  =  20.000\n");
    fprintf(textdiskfile,"   APEXLOC =   0.000  130.000  75.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     =   0.000 -130.000  75.000\n");
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    0.000   1.000\n");
    fprintf(textdiskfile,"   RADIUS  =  20.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");

	  /*  Closest Piston action - 1  */

    xp = 0.0 + 10.0 * CosD(phase + 0.0);
    zp = 75.0 + 10.0 * SinD(phase + 0.0);
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f -88.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f -108.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f -98.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    0.000   1.000\n");
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    xp = 0.0;
    zp = 75.0 + 20.0 + 10.0 + 10.0 * SinD(phase + 0.0) + 5.0;
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f -98.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  = 5.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f -98.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =   5.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f -98.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f -98.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f -98.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f -98.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    1.000   0.000\n");
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");

	  /*  Piston action - 2  */

    xp = 0.0 + 10.0 * CosD(phase + 180.0);
    zp = 75.0 + 10.0 * SinD(phase + 180.0);
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f -26.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f -46.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f -36.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    0.000   1.000\n");
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    xp = 0.0;
    zp = 75.0 + 20.0 + 10.0 + 10.0 * SinD(phase + 180.0) + 5.0;
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f -36.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  = 5.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f -36.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =   5.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f -36.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f -36.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f -36.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f -36.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    1.000   0.000\n");
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");

	  /*  Piston action - 3  */

    xp = 0.0 + 10.0 * CosD(phase + 90.0);
    zp = 75.0 + 10.0 * SinD(phase + 90.0);
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f 26.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 46.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 36.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    0.000   1.000\n");
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    xp = 0.0;
    zp = 75.0 + 20.0 + 10.0 + 10.0 * SinD(phase + 90.0) + 5.0;
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 36.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  = 5.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f 36.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =   5.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 36.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f 36.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 36.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 36.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    1.000   0.000\n");
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");

	  /*  Piston action - 4  */

    xp = 0.0 + 10.0 * CosD(phase + 270.0);
    zp = 75.0 + 10.0 * SinD(phase + 270.0);
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f 88.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 108.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 98.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    0.000   1.000\n");
    fprintf(textdiskfile,"   RADIUS  =  30.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    xp = 0.0;
    zp = 75.0 + 20.0 + 10.0 + 10.0 * SinD(phase + 270.0) + 5.0;
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"SPHERE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 98.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  = 5.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f 98.000 %3.3f\n",xp,zp);
    fprintf(textdiskfile,"   RADIUS  =   5.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 98.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CYLINDER\n");
    fprintf(textdiskfile,"   BASELOC = %3.3f 98.000 %3.3f\n",xp,(zp + 40.0));
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   APEXLOC = %3.3f 98.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"CIRCLE\n");
    fprintf(textdiskfile,"   LOC     = %3.3f 98.000 %3.3f\n",xp,(zp + 80.0));
    fprintf(textdiskfile,"   V1      =   1.000    0.000   0.000\n");
    fprintf(textdiskfile,"   V2      =   0.000    1.000   0.000\n");
    fprintf(textdiskfile,"   RADIUS  =  28.000\n");
    fprintf(textdiskfile,"   MATL    = STEEL\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"\n");
    fprintf(textdiskfile,"ENDFRAME\n");
    phase=phase+(360.0/numberofframes);
  }
}

void main()
{
  strcpy(filename,"ENGINE.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}