/*
  ͻ
                                                                          
                    Stack of Cannon Balls next to Cannon                  
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define Pi_Over_180 0.01745

float SinD(float a)
{
  return sin(a * Pi_Over_180);
}

float CosD(float a)
{
  return cos(a * Pi_Over_180);
}

typedef char name[33];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                 Stack of Cannon Balls next to Cannon                   \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.800    0.800    0.800\n");
  fprintf(textdiskfile,"   REFLWGT =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    1\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.500\n");
  fprintf(textdiskfile,"   OBSPOS  =   20.000  -700.000  100.000\n");
  fprintf(textdiskfile,"   ROTATE  =   -8.000\n");
  fprintf(textdiskfile,"   TILT    =    2.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SKY\n");
  fprintf(textdiskfile,"   HORCOL  =    0.400    0.500    0.600\n");
  fprintf(textdiskfile,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(textdiskfile,"   CLOUDS  = TRUE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = GRASS\n");
  fprintf(textdiskfile,"   TEXTURE = GRIT\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.250    0.600    0.290\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    4.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CANNONBLACK\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.250    0.270    0.250\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = WOODPOLE\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.300    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = OAKWOOD\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.300    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = REDFLAG\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.200    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = GRASS\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  350.000 -350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  120.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.980    0.980    0.910\n");
}

void sph(float x, float y, float z, float rad)
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z);
  fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
}

void make()
{
  Byte frame;
  float phase;
  float x1, y1, z1;
  float x2, y2, z2;
  float x3, y3, z3;
  float x4, y4, z4;
  float x5, y5, z5;
  float x6, y6, z6;
  float x7, y7, z7;
  float x8, y8, z8;
  float x9, y9, z9;
  float x0, y0, z0;
  float rad, hgt;
  float dx, dy;
  float zoffset;
  float scale;

  phase = 40.0;
  rad = 15.0;
  scale = rad * 2;
  zoffset = 0.0;   /*  sitting on ground  */
  writestudio();
     /*  Calculate the Positions of the Cannon Balls  */
  hgt = rad + zoffset;
  dx = CosD(phase);
  dy = SinD(phase);
  x1 = scale * dx;   /*  bottom layer  */
  y1 = scale * dy;
  z1 = hgt;
  dx = CosD(phase + 120.0);
  dy = SinD(phase + 120.0);
  x3 = scale * dx;
  y3 = scale * dy;
  z3 = hgt;
  dx = CosD(phase + 240.0);
  dy = SinD(phase + 240.0);
  x6 = scale * dx;
  y6 = scale * dy;
  z6 = hgt;
  x2 = (x1 + x3) / 2.0;   /*  p2 = (p1+p3) / 2  */
  y2 = (y1 + y3) / 2.0;
  z2 = hgt;
  x4 = (x1 + x6) / 2.0;   /*  p4 = (p1+p6) / 2  */
  y4 = (y1 + y6) / 2.0;
  z4 = hgt;
  x5 = (x3 + x6) / 2.0;   /*  p5 = (p3+p6) / 2  */
  y5 = (y3 + y6) / 2.0;
  z5 = hgt;
  hgt = hgt + rad * 2 * SinD(60);
  x7 = (x1 + x2 + x4) / 3.0;   /*  p7 = (p1+p2+p4) / 3.0   middle layer  */
  y7 = (y1 + y2 + y4) / 3.0;
  z7 = hgt;
  x8 = (x2 + x3 + x5) / 3.0;   /*  p8 = (p2+p3+p5) / 3.0  */
  y8 = (y2 + y3 + y5) / 3.0;
  z8 = hgt;
  x9 = (x4 + x5 + x6) / 3.0;   /*  p9 = (p4+p5+p6) / 3.0  */
  y9 = (y4 + y5 + y6) / 3.0;
  z9 = hgt;
  hgt = hgt + rad * 2 * SinD(60);
  x0 = 0.0;   /*  top layer  */
  y0 = 0.0;
  z0 = hgt;
     /*  Cannon Ball Stack at (0.0, 0.0, 0.0)  */
  sph(x1,y1,z1,rad);
  sph(x2,y2,z2,rad);
  sph(x3,y3,z3,rad);
  sph(x4,y4,z4,rad);
  sph(x5,y5,z5,rad);
  sph(x6,y6,z6,rad);
  sph(x7,y7,z7,rad);
  sph(x8,y8,z8,rad);
  sph(x9,y9,z9,rad);
  sph(x0,y0,z0,rad);
     /*  Cannon's Right Wheel  */
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -150.000 -60.000 50.000\n");
  fprintf(textdiskfile,"   V1      = 1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 0.000 1.000\n");
  fprintf(textdiskfile,"   RADIUS  = 50.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -150.000 -60.000 50.000\n");
  fprintf(textdiskfile,"   RADIUS  = 50.000\n");
  fprintf(textdiskfile,"   APEXLOC = -150.000 -40.000 50.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -150.000 -40.000 50.000\n");
  fprintf(textdiskfile,"   V1      = -1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 0.000 1.000\n");
  fprintf(textdiskfile,"   RADIUS  = 50.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
     /*  Cannon's Left Wheel  */
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -150.000 40.000 50.000\n");
  fprintf(textdiskfile,"   V1      = 1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 0.000 1.000\n");
  fprintf(textdiskfile,"   RADIUS  = 50.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -150.000  40.000 50.000\n");
  fprintf(textdiskfile,"   RADIUS  = 50.000\n");
  fprintf(textdiskfile,"   APEXLOC = -150.000  60.000 50.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -150.000 60.000 50.000\n");
  fprintf(textdiskfile,"   V1      = -1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 0.000 1.000\n");
  fprintf(textdiskfile,"   RADIUS  = 50.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
     /*  Cannon's Axle  */
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -150.000 -75.000 50.000\n");
  fprintf(textdiskfile,"   V1      = 1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 0.000 1.000\n");
  fprintf(textdiskfile,"   RADIUS  = 15.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -150.000  -75.000 50.000\n");
  fprintf(textdiskfile,"   RADIUS  = 15.000\n");
  fprintf(textdiskfile,"   APEXLOC = -150.000  75.000 50.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -150.000 75.000 50.000\n");
  fprintf(textdiskfile,"   V1      = -1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 0.000 1.000\n");
  fprintf(textdiskfile,"   RADIUS  = 15.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
     /*  Cannon with 19 degree tilt  */
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = -230.000  0.000 50.000\n");
  fprintf(textdiskfile,"   RADIUS  = 20.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -230.000  0.000 50.000\n");
  fprintf(textdiskfile,"   RADIUS  = 20.000\n");
  fprintf(textdiskfile,"   APEXLOC = -70.000  0.000 105.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"RING\n");
  fprintf(textdiskfile,"   LOC     = -70.000 0.000 105.000\n");
  fprintf(textdiskfile,"   V1      = 0.000 1.000 0.000\n");
  fprintf(textdiskfile,"   V2      = -0.325 0.000 0.946\n");
  fprintf(textdiskfile,"   RAD1    = 15.000\n");
  fprintf(textdiskfile,"   RAD2    = 20.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
     /*  Cannon's Fuse  */
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -220.000  0.000 60.000\n");
  fprintf(textdiskfile,"   RADIUS  = 5.000\n");
  fprintf(textdiskfile,"   APEXLOC = -225.000  0.000 82.000\n");
  fprintf(textdiskfile,"   MATL    = CANNONBLACK\n");
     /*  Cannon Ball being shot  */
  sph(-70.0 + 47.0,0.0,105.0 + 16.0,rad);
     /*  Flag Pole and Flag  */
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = 50.000  250.000 0.000\n");
  fprintf(textdiskfile,"   RADIUS  = 4.000\n");
  fprintf(textdiskfile,"   APEXLOC = 50.000  250.000 180.000\n");
  fprintf(textdiskfile,"   MATL    = WOODPOLE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = 50.000 250.000 180.000\n");
  fprintf(textdiskfile,"   V1      = 1.000 0.000 0.000\n");
  fprintf(textdiskfile,"   V2      = 0.000 1.000 0.000\n");
  fprintf(textdiskfile,"   RADIUS  = 4.000\n");
  fprintf(textdiskfile,"   MATL    = WOODPOLE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = 54.000 250.000 180.000\n");
  fprintf(textdiskfile,"   V1      = 0.000 0.000 -30.000\n");
  fprintf(textdiskfile,"   V2      = 40.000 0.000 0.000\n");
  fprintf(textdiskfile,"   MATL    = REDFLAG\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
}

void main()
{
  strcpy(filename,"CANNON.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}