/*
  ͻ
                                                                          
                                  Bounce                                  
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

#define piover180 0.01745

float SinD(Word a)
{
  return sin(a * piover180);
}

typedef char name[32];

FILE *textdiskfile;
name filename;

Word xresolution  = 160;
Word yresolution  = 100;
Byte numberofframes  = 30;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                                Bounce                                  \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    3\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.050\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    3.200\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000 -660.000  220.000\n");
  fprintf(textdiskfile,"   ROTATE  =    0.000\n");
  fprintf(textdiskfile,"   TILT    =   16.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SKY\n");
  fprintf(textdiskfile,"   HORCOL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   ZENCOL  =    0.700    0.800    1.000\n");
  fprintf(textdiskfile,"   CLOUDS  = TRUE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = PLASTICTILE\n");
  fprintf(textdiskfile,"   TEXTURE = CHECKER\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =    8.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"   TILE1   =    1.000    0.200    0.200\n");
  fprintf(textdiskfile,"   TILE2   =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TILE    =    0.012\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CHROME\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.500    0.500\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   GLOSS   =   30.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   25.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = REDMIRROR\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.050    0.050\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.500    0.100    0.100\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.300    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =   25.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = PLASTICTILE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  350.000 -350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     = -350.000 -350.000  350.000\n");
  fprintf(textdiskfile,"   RADIUS  =  100.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.950    0.950    0.910\n");
}

void make()
{
  Word theta;
  float x, y, z1;
  float z2, z3;
  float zoffset;
  float rad;

  theta = 0;
  rad = 40.0;
  zoffset = rad;
  x = 0.0;
  y = 0.0;
  z1 = 0.0;
  z2 = 0.0;
  z3 = 0.0;
  for (theta = 0; theta <= 180; theta++)
  {
    if (((theta % (180 / numberofframes)) == 0))
    {
      writestudio();
      z1 = zoffset + 90 * SinD(theta);
      z2 = zoffset + 70 * fabs(SinD(theta + 30));
      z3 = zoffset + 50 * fabs(SinD(theta - 45));
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"SPHERE\n");
      fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",x,y,z1);
      fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
      fprintf(textdiskfile,"   MATL    = CHROME\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"SPHERE\n");
      fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",(x + 2.5 * rad),y,z2);
      fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
      fprintf(textdiskfile,"   MATL    = BRASS\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"SPHERE\n");
      fprintf(textdiskfile,"   LOC     = %3.3f %3.3f %3.3f\n",(x - 2.5 * rad),y,z3);
      fprintf(textdiskfile,"   RADIUS  = %3.3f\n",rad);
      fprintf(textdiskfile,"   MATL    = REDMIRROR\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"BOUNDINGSPHERETEST\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"\n");
      fprintf(textdiskfile,"ENDFRAME\n");
    }
  }
}

void main()
{
  strcpy(filename,"BOUNCE.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",(int)numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}