/*
  ͻ
                                                                          
         2 State Finite Closed 2-Dimensional Life Cellular Automation     
                                                                          
                          Life Rule File Maker                            
                                                                          
                    (c) 1991 Christopher D. Watkins                       
                                                                          
  ͼ

  Rule : If an empty cell has exactly three neighbors it will be born. If an
  occupied cell has fewer than two or more than three neighbors it will die.

  Cell Arrangement :             I  J  K
				 L  M  N
				 P  Q  R

*/

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"

#define State 2
#define MaxState (State-1)
#define Born 1
#define Dead 0

typedef char Name[33];

Name RuleFileName;
FILE *RuleFile;
Word i, j, k;
Word l, m, n;
Word p, q, r;
Byte o;
Byte NumNeighbor;

void main()
{
  clrscr();
  printf("Generating Rule\n");
  strcpy(RuleFileName,"LRULE.CA");
  RuleFile=fopen(RuleFileName, "wb");
  for(i=0; i<=MaxState; i++)
  {
    for(j=0; j<=MaxState; j++)
    {
      for(k=0; k<=MaxState; k++)
      {
	for(l=0; l<=MaxState; l++)
	{
	  for(m=0; m<=MaxState; m++)
	  {
	    for(n=0; n<=MaxState; n++)
	    {
	      for(p=0; p<=MaxState; p++)
	      {
		for(q=0; q<=MaxState; q++)
		{
		  for(r=0; r<=MaxState; r++)
		  {
		    NumNeighbor=0;
		    if(i==Born)
		      ++NumNeighbor;
		    if(j==Born)
		      ++NumNeighbor;
		    if(k==Born)
		      ++NumNeighbor;
		    if(l==Born)
		      ++NumNeighbor;
		    if(n==Born)
		      ++NumNeighbor;
		    if(p==Born)
		      ++NumNeighbor;
		    if(q==Born)
		      ++NumNeighbor;
		    if(r==Born)
		      ++NumNeighbor;
		    if(m==Dead)
		    {
		      if(NumNeighbor==3)
			o=Born;			/*   bring it to life ?  */
		      else
			o=Dead;
		    }				/*  it's a live cell so  */
		    else
		    {
		      if((NumNeighbor<2)||(NumNeighbor>3))
			o=Dead;			/*            kill it ?  */
		      else
			o=Born;
		    }
		    putc(o, RuleFile);
		  }
		}
	      }
	    }
	  }
	}
      }
    }
  }
  fclose(RuleFile);
}