/*
  ͻ
                                                                          
              36 State Finite Closed Linear Cellular Automation           
                                                                          
                      (c) 1991 Christopher D. Watkins                     
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "alloc.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

#define MaxColumn 1024
#define MaxRow 768
#define States 36
#define MaxState (States-1)
#define WorldTop (MaxColumn-1)

typedef Byte State[36];
typedef Byte WorldArray[1024];
typedef State RuleI;
typedef RuleI Rule[36];

WorldArray NewWorld;
WorldArray OldWorld;
WorldArray TempWorld;
Word row;
Word i;
static Rule far *Rules;

void Pix()
{
  Plot(i, row, (NewWorld[i]<<4));
}

void DoWorld()
{
  /*  Mod operations can be used here -  */
  /*  but logical operations are faster  */

  i=0;
  NewWorld[i]=Rules[OldWorld[WorldTop]][OldWorld[i]][OldWorld[i+1]];
  Pix();
  for(i=1; i<=WorldTop-1; i++)
  {
    NewWorld[i]=Rules[OldWorld[i-1]][OldWorld[i]][OldWorld[i+1]];
    Pix();
  }
  i=WorldTop;
  NewWorld[i]=Rules[OldWorld[i-1]][OldWorld[i]][OldWorld[0]];
  Pix();
  _fmemcpy(TempWorld, NewWorld, sizeof(WorldArray));
  _fmemcpy(NewWorld, OldWorld, sizeof(WorldArray));
  _fmemcpy(OldWorld, TempWorld, sizeof(WorldArray));
  row=(row+1)%MaxRow;
}

typedef char Name[33];

Boolean RandWorld;
Name WorldFileName;
FILE *WorldFile;

void LoadWorld()
{
  Word i;

  row=0;
  if(RandWorld)
  {
    for(i=0; i<=WorldTop; i++)
      OldWorld[i]=RandInt(States);	 /*  Make up a Random World  */
  }
  else
  {
    if((WorldFile=fopen(WorldFileName, "rb"))==NULL)
    {
      ungetch(32);
      Exit_Graphics();
      printf("Can't open world file.\n");
      exit(1);
    }
    fread(OldWorld, sizeof(OldWorld), 1, WorldFile);
    fclose(WorldFile);
  }
}

Name Rulefilename;
FILE *Rulefile;

void LoadRules()
{
  if((Rulefile=fopen(Rulefilename, "rb"))==NULL)
  {
    ungetch(32);
    Exit_Graphics();
    printf("Can't open Rule file.\n");
    exit(1);
  }
  fread(Rules, sizeof(Rule), 36, Rulefile);
  fclose(Rulefile);
}

void ClearMemory()
{
  Word i, j, k;

  for(i=0; i<=WorldTop; i++)
  {
    NewWorld[i]=0;
    OldWorld[i]=0;
    TempWorld[i]=0;
  }
  for(i=0; i<=MaxState; i++)
  {
    for(j=0; j<=MaxState; j++)
    {
      for(k=0; k<=MaxState; k++)
	Rules[i][j][k]=0;
    }
  }
}

Palette_Register palarray;

void main()
{
  Rules=farcalloc(36, sizeof(Rule));
  if(Rules==NULL)
  {
    printf("can't get the mem!\n");
    exit(1);
  }
  ClearMemory();
  strcpy(WorldFileName,"WORLD1D.CA");
  strcpy(Rulefilename,"RULE1D.CA");
  RandWorld=false;   /*  when true -> WorldFileName := ''  */
  InitRand(0.4231966);
  LoadRules();
  LoadWorld();
  Init_Graphics(56);
  Init_Palette(palarray);
  Set_Palette(palarray);
  do
  {
    DoWorld();
  }
  while(!kbhit());
  Exit_Graphics();
  farfree(Rules);
}