//_________________________________________________________________________
//
//	Project: Moonlight
//	Module: Microkernel declarations for user code
//	Version: 1.0
//	File name: mmkernel.h
//	Author: Enrique Velasco Diaz
//_________________________________________________________________________
//

// Common helper macros

#ifndef max
	#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
	#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

#define DWORD unsigned 

//_________________________________________________________________________
//

// API prototypes and associated constants

void mK_yield(void);

//_________________________________________________________________________
//

void mK_init(void);
void mK_start(void);
void mK_end(void);

//_________________________________________________________________________
//

typedef struct
	{
	void *code; // address of process code starting point
	unsigned stack_size; // size of the stack area
	unsigned char default_priority;
	unsigned char current_priority;
	char *name; // process' symbolic name
	}TASK_INFO;

int mK_create_task(TASK_INFO *settings);
#define mKCREATPROC_NOMEM		-1

int mK_local_init(void);

//_________________________________________________________________________
//

int mK_self_pid(void);

//_________________________________________________________________________
//

int mK_get_task_info(int pid, TASK_INFO *info);
#define mKGETINFO_OK			0
#define mKGETINFO_BADPID		-1

//_________________________________________________________________________
//

int mK_set_task_info(int pid, TASK_INFO *info);
#define mKSETINFO_OK			0
#define mKSETINFO_BADPID		-1

//_________________________________________________________________________
//

void mK_kill_task(void);

//_________________________________________________________________________
//

void mK_enter_critical(void);
void mK_exit_critical(void);

//_________________________________________________________________________
//

int mK_create_semaphore(int value, int maximum);
#define mKCREATSM_NOMEM				-1
#define mKCREATSM_BADVALUE			-2
#define mKCREATSM_BADCEILING		-3

//_________________________________________________________________________
//

int mK_wait_semaphore(int semaphore);
#define mKWAITSM_SIGNAL			0
#define mKWAITSM_BADNUM			-1

//_________________________________________________________________________
//

int mK_signal_semaphore(int semaphore);
#define mKSIGNALSM_OK			0
#define mKSIGNALSM_BADNUM		-1
#define mKSIGNALSM_OVERFLOW		-2

//_________________________________________________________________________
//

int mK_delete_semaphore(int semaphore);
#define mKDELSM_OK				0
#define mKDELSM_BADNUM			-1
#define mKDELSM_BUSY			-2

//_________________________________________________________________________
//

typedef struct
	{
	int seconds;
	int minutes;
	int hours;
	int monthday;
	int month;
	int year;
	}mKTIME;

void mK_time_of_day(mKTIME *buffer);

//_________________________________________________________________________
//

unsigned int mK_get_systicks(void);

//_________________________________________________________________________
//

void *mK_malloc(int size);

//_________________________________________________________________________
//

int mK_mfree(void *block);
#define mKMFREE_OK				0
#define mKMFREE_BADPTR			-1

//_________________________________________________________________________
//

#define mKLOCAL_MACHINE			-1


int mK_non_blocking_send(int machine,
								 int receiver,
								 void *contents,
								 int length);

#define mKNBSEND_OK				0
#define mKNBSEND_BADPID			-1
#define mKNBSEND_OVERFLOW		-2

//_________________________________________________________________________
//

int mK_blocking_send(int machine,
							int receiver,
							void *message_contents,
							int message_length,
							void *reply_contents,
							int *reply_length);


#define mKBKSEND_OK			0
#define mKBKSEND_BADPID			-1
#define mKBKSEND_OVERFLOW		-2

//_________________________________________________________________________
//

int mK_receive(int *machine,
					int *pid,
					void *contents,
					int *length,
					int *reply_requested,
					DWORD delay);


#define mKRECEIVE_ARRIVAL		0
#define mKRECEIVE_ELAPSED		1
#define mKRECEIVE_NOTHING		2

#define mKWAIT_FOREVER			-1
#define mKNOWAIT				-2

//_________________________________________________________________________
//

int mK_respond(int machine,
					int receiver,
					void *contents,
					int length);

#define mKRESPOND_OK				0
#define mKRESPOND_BADPID		-1
#define mKRESPOND_BADSTATE		-2

//_________________________________________________________________________
//

int mK_freeze(int pid);
#define mKFREEZE_OK			0
#define mKFREEZE_BADPID			-1

//_________________________________________________________________________
//

int mK_unfreeze(int pid);
#define mKUNFREEZE_OK			0
#define mKUNFREEZE_BADPID		-1
#define mKUNFREEZE_NOFROZEN		-2

//_________________________________________________________________________
//

typedef struct
	{
	// general information
	int how_many; // total number of tasks in the system

	// task profiler info
	int times_entered;
	int time_running;

	// other status info
	int process_state; // detailed state

	#define READY		1
	#define RUNNING		2
	#define PENDING		3
	#define RECEIVING	4
	#define EXPECTING	5
	#define FROZEN		6



	unsigned stack_size;
	unsigned char default_priority;
	unsigned char current_priority;
	char *symbolic_name;
	}mKTASK_INFO;

int mK_get_task_snapshot(int task, mKTASK_INFO *buffer);

#define mKGTASKINFO_OK			0
#define mKGTASKINFO_BADPID		-1

//_________________________________________________________________________
//

typedef struct
	{
	short value;
	short maximum;
	int *waiting_tasks; // a large enough space must be previously allocated
	}mKSEM_INFO;

int mK_get_semaphore_snapshot(int semaphore, mKSEM_INFO *buffer);

#define mKGSEMINFO_OK			0
#define mKGSEMINFO_BADNUM		-1

//_________________________________________________________________________
//

int mK_profiler_control(int command, int task);

#define mKPROF_ON				1
#define mKPROF_OFF				0
#define mKPROF_RESET			2

#define mKPROFCNT_OK			0
#define mKPROFCNT_BADCOMMAND		-1
#define mKPROFCNT_BADPID		-2

//_________________________________________________________________________
//

typedef struct
	{
	void *block_address;
	int block_size;
	int owner_task;
	}mKBLOCK_INFO;

mKBLOCK_INFO *mK_heap_view(void);

//_________________________________________________________________________
//


