;  [PCXCOM]
;          Copyright (C) 1996 by Mika Tanska , M.TANSKA Software       
;                           ALL RIGHTS RESERVED                        
;                     e-mail: mitanska@freenet.hut.fi                  
;  1996  

; Compile this file:
; Turbo Assembler:   TASM PCXCOM.ASM
; Turbo Link     :   TLINK /T PCXCOM.OBJ

_code    segment word public 'code'
	 assume  cs:_code,ds:_code
	 .186
	 locals
org      100h

StartUp: jmp  main

get_param proc near
         mov  al,ds:[80h]         ; Get length of parameter
	 cmp  al,2                ; Is parameter longer than 2 bytes
	 jb   @@err               ; No, it's shorter jump error
	 
	 mov  si,82h              ; Here's start the real parameter
	 mov  di,offset fname     ; DI is now pointing FNAME
	 
@@1:     lodsb                    ; Get byte to AL
	 
	 cmp  al,32               ; Is AL space (ascii 32)
	 je   @@end               ; Yes jump @@end
	 
	 cmp  al,13               ; Is AL enter (ascii 13)
	 je   @@end               ; Yes jump @@end
	 
	 mov  [di],al             ; Let's store AL to fname
	 inc  di                  ; Add DI one
	 jmp  @@1	          ; Let's repeat that stuff again
	 
@@err:
         mov  dx,offset Error02_  ; DX is now pointing error02_ (usage...)
	 mov  ah,09h              ; Dos print string function
	 int  21h                 ; Do it, print string
	 
	 mov  ah,4Ch              ; Dos terminate program function
	 int  21h                 ; Do it, end program

@@end:
         mov  [di+0],byte ptr 0   ; Put end of fname ascii 0
	 mov  [di+1],byte ptr 8   ; Put end of fname ascii 8
	 mov  [di+2],byte ptr 36  ; Put end of fname ascii 36
	 	                  ; We need these to end of file asciiz
         ret
get_param endp

do_checks proc near
         mov  ah,3Fh              ; Dos read file function
	 mov  bx,[F]              ; BX = file handle
	 mov  cx,128              ; We read 128 bytes from file
	 mov  dx,offset header    ; DX is now pointing header
	 int  21h                 ; Do that stuff, read from file
	                          ; Return AX number bytes read
	 cmp  cx,ax               ; Was bytes 128 ?
	 jne  @@err               ; Nope, let's do the error thing
	 
	 mov  si,offset header    ; SI is now pointing header
	 
	 lodsb                    ; Get byte AL
	 cmp  al,10               ; Is AL PCX manufacturer (10) ?
	 jne  @@err               ; Nope, do the error thing
	                          ; That same stuff here below
	 lodsb
	 cmp  al,5
	 jne  @@err
	 
	 lodsb
	 cmp  al,1
	 jne  @@err
	 
	 lodsb
	 cmp  al,8
	 jne  @@err
	 
	 add  si,2                ; jump over Xmin
	 
	 lodsw
	 cmp  ax,0
	 jne  @@err
	 
	 add  si,2                ; jump over Xmax
	 
	 lodsw
	 cmp  ax,199
	 jne  @@err
	 
	 add  si,2+2+48+1+1       ; HDpi,VDpi,ColorMap,Reserved,NPlanes
	 
	 lodsw
	 cmp  ax,320
	 jne  @@err
	 
         ret
@@err:
         mov  dx,offset error01_  ; DX is now pointing error01_ (file is...)
	 mov  ah,09h              ; Dos print string function
	 int  21h                 ; DO IT
	 
	 mov  ah,4Ch              ; Dos terminate program function
	 int  21h                 ; DO IT
do_checks endp

unpack   proc near
         mov  cx,255	          ; CX = number of colors
@@pal1:  mov  ax,cx               ; AX = CX
	 mov  dx,3C8h             ; DX = bios port number 3C8h
	 out  dx,al               ; Write color number to port 3C8h
	 
	 mov  dx,3C9h             ; DX = bios port number 3C9h
	 xor  ax,ax               ; -> AX = 0
	 
	 out  dx,al               ; Write 0 to port 3C9h
	 out  dx,al               ;       - " -
	 out  dx,al               ;       - " -
	 loop @@pal1              ; CX=0 ? if no then loop @@pal1
	 
         xor  di,di               ; -> AX = 0
	 mov  si,offset pcxdata   ; SI is now pointing pcxdata
	 
@@1:     cmp  di,64000            ; End of screen ? 
	 jae  @@3                 ; Yes jump @@3
	 
	 lodsw                    ; Get AX word
	 cmp  al,192              ; Is top 2 bit set
	 jae  @@2                 ; Yes jump @@2
	 
	 stosb                    ; Put byte to video memory (ES:DI)
	 dec  si                  ; Decrement SI because we dont't use AH yet
	 jmp  @@1                 ; Jump @@1
	 
@@2:	 and  al,00111111b        ; Set of high two bits
         mov  cl,al               ; CL=AL , CL will will use looper, later
	 xor  ch,ch               ; -> CH = 0
	 xor  al,al               ; -> AL = 0
	 xchg al,ah               ; AL = AH and AH = AL
	 rep  stosb               ; Repeat : dec CX , put byte(AL) to videomem.
	 jmp  @@1	          ; Jump @@1

@@3:     lodsb                    ; Get Palette ID. We don't check it
         xor  cx,cx               ; -> CX = 0
@@4:	 mov  ax,cx               ; AX = CX , color number
	 mov  dx,3C8h             ; DX = bios port number 3C8h
	 out  dx,al               ; Write color number to port 3C8h
	 
	 mov  dx,3C9h             ; DX = bios port number 3C9h
	 
	 lodsb                    ; Get byte AL
	 shr  al,2                ; Div AL 4
	 out  dx,al               ; Write AL to port 3C9h
	 
	 lodsb                    ; Get byte AL
	 shr  al,2                ; Div AL 4
	 out  dx,al               ; Write AL to port 3C9h
	 
	 lodsb                    ; Get byte AL
	 shr  al,2                ; Div AL 4
	 out  dx,al               ; Write AL to port 3C9h
	 
	 inc  cx                  ; Increment CX
	 cmp  cx,255              ; Is CX 255
	 jb   @@4                 ; Not yet, jump @@4
	 
	 ret
unpack   endp	 


; MAIN PROCEDURE 
main     proc near
         push 0a000h              ; ES = 0A000h
	 pop  es
	 call get_param           ; Call get_param procedure
	 
	 mov  ah,3Dh              ; Dos open file function
	 mov  al,00h              ; Open mode : 00h = read only
	 mov  dx,offset fname     ; DX is now pointing fname
	 int  21h                 ; Do it
	 
         jnc  @@cool              ; If CF=0 then jump @@cool
	 mov  dx,offset Error00_  ; DX is now pointing error00_
	 mov  ah,09h              ; Dos print string function
	 int  21h                 ; Do it
	 jmp  @@ende              ; Jump @@ende
	 
@@cool:  mov  [F],ax              ; F = AX (AX = file handle)
         call do_checks           ; Call do_checks procedure
	 
	 mov  ah,3Fh              ; Dos read file function
	 mov  bx,[F]              ; BX = file handle
	 mov  cx,DataBuf          ; CX = DataBuf
	 mov  dx,offset pcxdata   ; DX is now pointing pcxdata
	 int  21h                 ; Do it, read file
	 
	 mov  ax,0013h            ; Bios set video mode function (mode 13h)
	 int  10h                 ; Do it, set 256 color mode
	 
	 call unpack              ; Call unpack pcx
	 
	 mov  ah,3Eh              ; Dos close file function
	 mov  bx,[F]              ; BX = file handle
	 int  21h                 ; Do it
	 
	 xor  ah,ah               ; Bios wait for key function
	 int  16h                 ; Do it, stop here and wait key
	 
	 mov  ax,0003h            ; Bios set video mode function (mode 3h)
	 int  10h                 ; Do it, set text mode

@@ende:                           ; Well,well program has end
         mov  ah,4Ch              ; Dos terminate program function
	 int  21h                 ; Do it
         ret
 
main     endp

DataBuf  =    60000

Error00_ db   'Can''t locate file !',10,13,7,36
Error01_ db   'File is not 320x200x256 PCX-picture !',10,13,7,36
Error02_ db   'Usage: PCXCOM <file>',10,13,36
F	 dw   (?)
Fname    db   130 dup (?)
Header   db   128 dup (?)
PCXDATA  db   DataBuf dup (?)
_code    ends
	 end StartUp