;****************************************************************************
; Filename: STDDEF.INC
;   Author: Peter Andersson
;  Comment: Included in all assembler files to initiate the assembler
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************

        Ideal
        P486

        LargeStack
        Model   NearStack Flat,C

    Segment _BSS
    Ends _BSS

    Group FLAT _BSS
        Assume  Cs:FLAT, Ds:FLAT, Es:FLAT, Fs:FLAT, Gs:FLAT, Ss:FLAT

        NoSmart         ; Smart code generation
        Locals          ; Allow local labels
        NoJumps         ; No smart jumps
        MultErrs        ; Warn with multiple errors

                        ; Warnings:
        Warn    BRK     ; brackets needed []
        Warn    GTP     ; type declared must match
        Warn    ICG     ; inefficient code generation
        Warn    LCO     ; location counter overflow
        Warn    OVF     ; overflow
        Warn    PRO     ; code segment override

                        ; No warnings:
        NoWarn  RES     ; reserved words

MACRO   ENTERD  Locals:REQ, Nesting:REQ
IF Nesting EQ 0
                Push    Ebp
                Mov     Ebp, Esp
IF Locals NE 0
IF (Locals AND 3) NE 0
                Sub     Esp,(Locals AND NOT 3)+4
ELSE
                Sub     Esp,Locals
ENDIF
ENDIF
ELSE
                Enterd  Locals, Nesting
ENDIF
ENDM    ENTERD

MACRO   ENTERW  Locals:REQ, Nesting:REQ
IF Nesting EQ 0
                Push    Bp
                Mov     Bp,Sp
IF Locals NE 0
IF (Locals AND 1) NE 0
                Sub     Esp,(Locals AND NOT 1)+2
ELSE
                Sub     Esp,Locals
ENDIF
ENDIF
        Else
                Enterd  Locals, Nesting
        Endif
ENDM    ENTERW

MACRO   LEAVED
                Mov     Esp,Ebp
                Pop     Ebp
ENDM    LEAVED

MACRO   LEAVEW
                Mov     Sp,Bp
                Pop     Bp
ENDM    LEAVEW

MACRO   Clear xData:REQ
                Xor     xData,xData
ENDM    Clear

MACRO   TestZ xData:REQ
                Test    xData,xData
ENDM    TestZ

MACRO   Push xReg:REST
ERRIFB <xReg> "PUSH must have arguments"
IRP _ESP_R_,<xReg>
                PUSH    _ESP_R_
ENDM
ENDM    Push

MACRO   Pop xReg:REST
    ERRIFB <xReg> "POP must have arguments"
    IRP _ESP_R_, <xReg>
        _ESP_P_ SUBSTR <_ESP_R_>,1,1
        IFDIF _ESP_P_,<+>
                        POP     _ESP_R_
        ELSE
        _ESP_P_ SUBSTR <_ESP_R_>,2
        IFNB _ESP_P_
                        LEA  Esp,[Esp+ _ESP_P_]
        ENDIF
        ENDIF
    ENDM
ENDM    Pop

CRLF    EQU     <13,10>
CR      EQU     <13>
LF      EQU     <10>


Macro   _cdecl  Func:REQ,Regs:REQ
        If Regs Eq 0
;               Jmp     Func
        Elseif Regs Eq 1
                Mov     Eax,[Esp+4]
;               Jmp     Func
        Elseif Regs Eq 2
                Mov     Eax,[Esp+4]
                Mov     Edx,[Esp+8]
;               Jmp     Func
        Elseif Regs Eq 3
                Mov     Eax,[Esp+4]
                Mov     Edx,[Esp+8]
                Mov     Ecx,[Esp+12]
;               Jmp     Func
        Elseif Regs Ge 4
                Mov     Eax,[Esp+4]
                Mov     Edx,[Esp+8]
                Mov     Ecx,[Esp+12]
CNT=Regs*4+4
        Rept    Regs-3
                Push    [Dword Esp+Regs*4]
        Endm
                Call    Func
                Add     Esp,Regs*4-12
                Ret
        Endif
Endm    _cdecl


IFDEF FASTCALL_ONLY
    MACRO Proc Func, NumArgs
        IFNB <NumArgs>
            proc   @&Func NoLanguage
        ELSE                    
            proc    Func
        ENDIF
   ENDM  Proc

ELSE            
    
    MACRO Proc Func, NumArgs
        IFNB <NumArgs>
            Func&:
            _cdecl  @&Func, NumArgs
            proc   @&Func NoLanguage
        ELSE                    
            proc    Func
        ENDIF
    ENDM Proc

ENDIF

Include "PAL.INC"
