; Tiny Serpinsky Triangle Generator v96.7.12.11p
; (like my version system?)
; Copyright (c) 1996, Justin Frankel
; Additional size optimizations by Kevin Vigor
; XCHG tip thanks to Richard Pavlicek (1 byte saved)
;
; optimized for size - should assemble to a 56 byte .COM file
;

VGA320  equ 0 ;
VGA640  equ 1 ; set the appropriate resolution to 1.
SVGA800 equ 0 ;

if SVGA800 ; VESA SVGA 800x600x16
VID_MODE equ 6Ah
SCR_WIDTH equ 800
SCR_HEIGHT equ 600
elseif VGA640 ; VGA 640x480x16
VID_MODE equ 12h
SCR_WIDTH equ 640
SCR_HEIGHT equ 480
elseif VGA320 ; VGA 320x200x256
VID_MODE equ 13h
SCR_WIDTH equ 320
SCR_HEIGHT equ 200
endif

.8086
.model tiny
.code

.startup
        mov al, VID_MODE
        int 10h
        mov di, 3
BigLoop:
        mov dx, 9421
        mul dx
        inc ax
        push ax
        sub dx, dx
        div di
        dec dx
        jz short L2
        jns short L1
        add si, SCR_HEIGHT
        sub cx, SCR_WIDTH/2
L1:
        add cx, SCR_WIDTH
L2:
        shr cx, 1
        shr si, 1

        mov ah, 0Ch
        mov dx, si
        int 10h

        mov ah, 1
        int 16h
        pop ax
        jz short BigLoop

        xchg ax, di
        int 10h
        ret
END


; Draws a Serpinski triangle
; David Stafford
; 7/14/96
; 8086 code, assemble to a COM file
; 31 bytes

code            segment
                assume  cs:code,ds:code,es:code,ss:code

                org     100h            ;for COM files
Start:
                mov     al,13h          ;assume ah = 0 (true for COM files)
                int     10h             ;set VGA 320x200 256-color mode

                mov     bx,0A1E0h - 320 ;ds = video memory, bx = offset
                mov     ds,bx           ;small and very cute, the segment
                                        ;and offset are identical

                mov     al,15           ;a white pixel- can eliminate this
                                        ;to save 2 bytes but the color is
                                        ;too dark
DrawLoop:
                mov     [bx-318],al     ;order is important
                mov     al,[bx+2]       ;two pixels...
                xor     al,[bx]

                dec     bx              ;dec pointer
                jnz     DrawLoop

                int     16h             ;assume ah = 0, wait for keystroke
                                        ;unfortunately, this fills ah...

                mov     ax,3            ;...so we have to clear it here
                int     10h             ;set 80x25 text mode

                ret                     ;exit (returns to cs:0000 where
                                        ;there is an INT 20h for COM files)

                ends
                end     Start


I found a way to keep the color visible and squeezed a couple more
bytes out of my code.

; Draws a Serpinski triangle
; David Stafford
; 7/15/96
; 8086 code, assemble to a COM file
; 29 bytes

code            segment
                assume  cs:code,ds:code,es:code,ss:code

                org     100h            ;for COM files
Start:
                mov     al,13h          ;assume ah = 0 (true for COM files)
                int     10h             ;set VGA 320x200 256-color mode

                mov     bl,3            ;bx = 3, assume bh = 0
                                        ;comes in handy in two places below

                mov     si,0A1E0h - 320 ;ds = video memory, si = offset
                mov     ds,si           ;small and very cute, the segment
                                        ;offset and counter are identical

                db      0b9h            ;MOV CX,0C8Bh where 0C = color red
                                        ;skip the next instr the first time
                                        ;I can make this use white but it
                                        ;costs one more byte
DrawLoop:
                mov     cx,[si]         ;order is important!  8B 0C
                xor     ch,[bx+si]      ;handy place #1 (bx = 3)
                mov     [si-318],ch

                dec     si              ;dec pointer
                jnz     DrawLoop

                int     16h             ;assume ah = 0, wait for keystroke

                xchg    ax,bx           ;handy place #2 (bx = 3)
                int     10h             ;set 80x25 text mode

                ret                     ;exit (returns to cs:0000 where
                                        ;there is an INT 20h for COM files)
                ends
                end     Start

From: kemp@gil.com.au

;For those of you who dislike compiled bitmaps, here's a 14h (sounds better
;than 20) byter. Might be fairly dark on some monitors.
;There's some purposeful minor incorrectness in the algorithm causing an
;off-by-one error or two in order to save a few bytes.

.8086
.model tiny
.code
.startup
mov al,13h
int 10h    ;if already in graphics mode, can save two bytes here.
x:
mov dl,cl
and dl,bl
mov ah,0ch
int 10h
mid:
dec cl
jnz short x
inc bl
jnz short mid

;ret ;optional for achieving goal, saves a byte if not used.
END


