;==========================================================
;PROGRAM: EMEM.ASM (based on EMEM.C)
; AUTHOR: Denis Boyles
;RELEASE: Public Domain (Nov 26, 1996)

;COMPILE: Arrowsoft Assembler v1.00D (MASM v3.x compatible)
;     OS: DOS (MSv6.20)

;PURPOSE: reports your environment memory usage
;==========================================================

CODE SEGMENT
    ASSUME CS:CODE,DS:CODE,ES:CODE,SS:CODE
    ORG 0100h

;--------------------------------------
; MAIN - program entry
;--------------------------------------

MAIN:
    jmp     START

;--------------------------------------
; DATA - data is kept in here
;--------------------------------------

total       dw ?                       ;variable for total env space
used        dw ?                       ;variable for used env space

report      db 00Dh,00Ah,'Total Environment Space: '
rt          db '      bytes.',00Dh,00Ah
            db ' Used Environment Space: '
ru          db '      bytes.',00Dh,00Ah
            db '------------------------ ----- ------',00Dh,00Ah
            db ' Free Environment Space: '
rf          db '      bytes.',00Dh,00Ah,'$'

;--------------------------------------
; DecToAsc - convert 16bit num to ASCII
;   AX <= number
;   DI <= offset of buffer
;--------------------------------------

DecToAsc proc
    mov     CX,10000                   ;divide number by 10,000 to calculate
    call    DivIt                      ;the ten thousandth place number
    mov     AX,DX                      ;take remainder for next divide

    mov     CX,1000                    ;divide number by 1,000 to calculate
    call    DivIt                      ;the thousandth place number
    mov     AX,DX                      ;take remainder for next divide

    mov     CX,100                     ;divide number by 100 to calculate
    call    DivIt                      ;the hundredth place number
    mov     AX,DX                      ;take remainder for next divide

    mov     CX,10                      ;divide number by 10 to calculate
    call    DivIt                      ;the tenth place number
    mov     AX,DX                      ;the remainder is the ones number

    add     AL,48                      ;covert number to ASCII by adding 48
    stosb                              ;'0' and store it in buffer
    ret
DecToAsc endp

;--------------------------------------
; DivIt - used by DecToAsc to divide
;--------------------------------------

DivIt proc
    xor     DX,DX                      ;zero out DX for 16bit divide
    div     CX                         ;divide DX:AX by CX
    add     AL,48                      ;convert quotient to ASCII by adding
    stosb                              ;48 '0' and then store it in place
    ret
DivIt endp

;--------------------------------------
; eSize - get environment allocation
;   AX >= bytes allocated
;--------------------------------------

eSize proc
    push    ES                         ;save ES on stack

    mov     AX,0352Eh                  ;get vector for INT 2Eh
    int     021h                       ;ES:BX -> COMMAND.COM?

    mov     AX,ES:[02Ch]               ;get environment segment from PSP of
    dec     AX                         ;COMMAND.COM and decrement for it's
    mov     ES,AX                      ;MCB structure (master env?)

    mov     AX,ES:[003h]               ;get the size of the MCB in paras
    mov     CL,4                       ;and left shift by 16 (4) to convert
    shl     AX,CL                      ;to bytes and save it in memory
    mov     word ptr [total],AX

    pop     ES                         ;restore ES from stack
    ret
eSize endp

;--------------------------------------
; eUsed - get used environment space
;   AX >= bytes used
;--------------------------------------

eUsed proc
    push    DS                         ;save DS to stack

    mov     AX,DS:[02Ch]               ;set DS to point to `our' environment
    mov     DS,AX                      ;by taking the evironment segment
    xor     SI,SI                      ;from the PSP. Zero our SI counter

CntByte:                               ;SI counts for us for each byte
    cmp     word ptr [SI],0            ;are we at last entry and end of env?
    jz      ExByte                     ;YES then stop counting
    inc     SI                         ;no, increment our counter
    jmp     CntByte                    ;keep counting until the end

ExByte:
    add     SI,2                       ;include the two NULLs aswell.
    pop     DS                         ;YES restore DS from stack

    mov     word ptr [used],SI         ;save used space (SI) to variable
    mov     AX,SI                      ;copy to AX for return value
    ret
eUsed endp

;--------------------------------------
; eFree - get free enviroment space
;   AX >= free space in bytes
;--------------------------------------
eFree proc
    mov     AX,[total]                 ;AX = total - used
    sub     AX,[used]
    ret
eFree endp


;--------------------------------------
; START - program really begins here
;--------------------------------------

START:
    call    eSize                      ;get the total allocated size of env
    mov     [total],AX                 ;save to variable
    mov     DI,offset rt               ;set offset into report buffer
    call    DecToAsc                   ;`print' number to our report buffer

    call    eUsed                      ;get the used space of the env
    mov     [used],AX                  ;save to variable
    mov     DI,offset ru               ;set offset into report buffer
    call    DecToAsc                   ;`print' number to our report buffer

    call    eFree                      ;get the free space left in env
    mov     DI,offset rf               ;set offset into report buffer
    call    DecToAsc                   ;`print' number to our report buffer

    mov     AH,009h                    ;DOS print a string
    mov     DX,offset report           ;DS:DX -> to our report text
    int     021h                       ;print the results

    mov     AX,04C00h                  ;DOS terminate with code (0)
    int     021h                       ;terminate program

CODE ENDS
END MAIN
