; DPMI.ASM -- Based on sample source originally from DPMISPEC.TXT
; Switches to protected mode and prints a message.

; Rowan Crowe, 3:635/727@fidonet
;              rowan@jelly.freeway.dialix.oz.au

; Released to the public domain.

; NOTE: May not run under all DPMI implementations. It will most
;       likely not work with a "pure DPMI only" host.

;       Uncomment the "mov word ptr cs:[__test], 0" line to
;       observe that writes to the code segment cause an
;       exception #13 (General Protection Fault) in PM

; Assemble with:   tasm dpmi /m
;                  tlink dpmi /t

;                  masm dpmi;
;                  link dpmi /t;

;                  asm dpmi;
;                  link dpmi /t;

;                  a86 dpmi.asm

code segment
assume cs:code, ds:code
org 100h
.286

start:
        mov     sp,offset _end + 1024
        mov     bx,sp
        shr     bx,4
        add     bx,17
        mov     ah,4ah
        int     21h      ; resize memory block
        jc      Cant_Enter_PMode

        mov     ax,1687h
        int     2Fh      ; get PM switch entry address
        test    ax,ax
        jnz     Cant_Enter_PMode
        mov     word ptr [PMode_Entry_Seg],es
        mov     word ptr [PMode_Entry_Off],di

        or      si,si   ; SI = number of paras required by extender
        jz      Enter_PMode_Now
        mov     bx,si
        mov     ah,48h
        int     21h      ; allocate conventional memory for extender
        jc      Cant_Enter_PMode
        mov     es,ax

        mov     ah,9
        mov     dx,offset __almostPM
        int     21h      ; Just about to enter PM

Enter_PMode_Now:
        xor     ax,ax
        call    DWORD PTR [PMode_Entry_Off]  ; PM, here we come!
        jc      Cant_Enter_PMode             ;   :-(

; We're now running in protected mode.

        mov     ah,9
        mov     dx,offset __inPM
        int     21h                          ; Smile cos we're in PM

;        mov     word ptr cs:[__test],0       ; Writes to CS cause GPF
                                             ; in PM

        mov     ax,4C00h                    ; End program
        int     21h

Cant_Enter_Pmode:
        mov     ah,9
        mov     dx,offset __noPM
        int     21h
        mov     ax,4c01h
        int     21h

__test      dw ?

__noPM      db 'Can''t enter protected mode :-(',13,10,'$'
__almostPM  db 'About to enter protected mode',13,10,'$'
__inPM      db 'We''re now in protected mode :-)))))',13,10
            db 'Exiting to DOS now...',13,10,'$'

PMode_Entry_Off  dw ?
PMode_Entry_Seg  dw ?

_end:
code ends

end start

