; 386POWER INCLUDE FILE
; VIRTUAL 80x86 REGISTER IMAGE
extrn   V86eax:dword, V86ebx:dword, V86ecx:dword, V86edx:dword
extrn   V86esi:dword, V86edi:dword, V86ebp:dword
extrn   V86ah:byte, V86al:byte, V86bh:byte, V86bl:byte
extrn   V86ch:byte, V86cl:byte, V86dh:byte, V86dl:byte
extrn   V86ax:word, V86bx:word, V86cx:word, V86dx:word
extrn   V86si:word, V86di:word, V86bp:word
extrn   V86ds:word, V86es:word, V86fs:word, V86gs:word

; GLOBAL VARS
extrn   _SelCode:word, _SelData:word, _SelZero:word, _LoMemBase:dword
extrn   _LoMemTop:dword, _HiMemBase:dword, _HiMemTop:dword, _PSPBase:dword
extrn   _Code16Base:dword, _Code32Base:dword, _OldInt:dword:256

; _386Return is a pointer (into low memory) to the first exit message
; _386Terminator is the default  exit message
extrn   _386Return:dword, _386Terminator:byte

; protected-to-realmode entry points
extrn _ExecINT:dword
;               replaces INT 33h from prot. mode

extrn _ExecReal:dword
;               replaces INT 32h from prot. mode

; These two _GetIRQ and _SetIrq are NEAR POINTERS to the routines needed
; to set protected mode irq handlers

; _GetIRQ:
; BL = IRQ number
; EDX = OFFSET  of the irq routine (selector is always code32)
extrn _GetIRQ:dword

; _SetIRQ:
; BL = IRQ NUMBER ( the irq line it uses, NOT the interrupt number)
;                  IRQ 0..7   == "real mode int"   8..0Fh
;                  IRQ 8..0Fh == "real mode int" 70h..77h
;
; EDX = OFFSET  of the irq routine (selector is always code32)
;
; The routine pointed by EDX is set as the new PROTECTED MODE
; handler for the IRQ.
; Usually when a "new" protected mode handler is set
; the dos-extender "places" into the real mode interrupt table
; a routine called "interrupt reflector" that redirects the
; irq handling to the protected mode handler you set.
; (this way you don't need to worry "where" the irq happens).
; The only expection to this rule is when running under VCPI (i.e EMM386)
; the VCPI server "interacts" with IRQ0 and IRQ1 in a strange way
; so the VCPI "set irq" code does not redirects those IRQs
; IF YOU WANT, call the ms-dos get/set interrupt functions (using _ExecINT)
; and set those IRQ directly.
;
; If you call _SetIRQ with EDX=default irq handler
; then the "real mode handling" is set as it was at 386P startup
; (this happens for IRQ0 and IRQ1 too!!!! So you can avoid to
;  call _ExecINT again if you took'em over yourself).
extrn _SetIRQ:dword


; Similar to the get/set irq these routines enable or disable
; the IRQ LINE on the Programmable Interrupt Controller
; call them with:
; bl = IRQ number
; al = IRQ flag status (0 = enabled, 1= disabled)
extrn _GetIRQMask:near, _SetIRQMask:near

; 386 MANager type
extrn   _386Man:byte
; possible values of _386Man
IS_VCPI  = 0
        ; VCPI server (i.e. EMM386)
IS_DPMI  = 1
        ; Usually Windows or OS/2
IS_XMS   = 2
        ; HIMEM.SYS
IS_HARD  = 3
        ; Nothing, we will have to go directly to hardware

; CPU type
extrn   _CPUPower:byte
; CPU class : 0=8086 , 1=186, 2=286, 3=386, 4=486, 5=586
; N.B. no info is told about the FPU (i.e 486 can be a 486DX or a 486SX)

; routines to allocate memory
; IN: eax= size
;
; OUT: if CARRY_FLAG clear then 
;               eax = offset of allocated block (code32 relative)
;      else
;               not enough memory available
;
; _GetLoMem tries to allocate memory into dos ram (the first 640k)
; _GetHiMem tries to allocate memory into extended ram (beyound the 1st mega)
; _GetMem   tries first dos, then extended ram
extrn   _GetMem:near, _GetLoMem:near, _GetHiMem:near

; terminates program, sets text mode 03h and restores all interrupt handlers
extrn   _Exit:near 

extrn   _OnExit:near ; add a subroutine to the code executed when _Exit 
                     ; is called.
                     ; EAX = subroutine offset
                     ;       the subroutine must preserve the segment registers
                     
extrn   _MapPhysMem:near 
; Maps a physical memory block to a code32 relative offset
; This is useful to "map in" physical memory
; (i.e. the vram of a video card supporting linear addressing).
; It is supposed the memory block is NOT ALREADY MAPPED
; ABSOLUTELY DON'T TRY to use this function to tunnel thru the paging hardware
; and fuck the paging system, nasty things will happen if you try
; to do this.
; IN: eax = base address of physical memory block
;     edx = size of block to map
; OUT:
;     if CARRY CLEAR then
;               eax = code32 relative offset equivalent to phys. base address
;     else
;              mapping failed
;     end-if
;
; WARNING! Under VCPI a maximum of 4Mbytes can be allocated for direct mapping.
; This is wide enough for the most common uses
; but if you don't think so, please let me know.
        


CR = 13
LF = 10

; Virtual DMA services allocate data in the low memory heap
; (always reachable)
; and store a description of it into a "scatterlist"
; to let you "see" directly how pages are mapped
; (this is necessary to directly access the allocated region
;  on a page-by-page method that lets you "disable" the slow
;  and sometimes erratic dma-translation)
; the following dwords are POINTERS to the actual routines
; i.e. if you want to get dma info, perform:   CALL _DMAInfo

extrn _DMAInfo:dword
; out: carry clear if DMA support is present

extrn _DMAInit:dword
;Initializes the VDMA system
; out: Carry clear if OK
;      eax=number of dma channels

; hook to virtual dma services or emulate 'em
extrn _DMALock:dword
; Locks a DMA channel (disables automatic dma translation)
; this way it is possible to use the _DMASend and _DMAReceive functions
; and other tasks cannot use it
; IN:  EAX = channel number
; OUT: Carry set if error

extrn _DMAUnLock:dword
; Unlocks a DMA channel & re-enables automatic dma translation
; so other tasks can freely use it.
; (do this BEFORE program termination, or your system may hang)
; IN:  EAX = channel number
; OUT: Carry set if error

extrn _DMASend:dword
; Sends data TO a device using DMA
; EAX = channel, EBX = Physical mem ptr, ECX = Lenght in BYTES
; n.b.if you send/receive on a 16bit channel (4..7) remember to keep
;     address and byte count WORD ALIGNED
; Remember that it is better if send data in chunks 4k bytes
; starting dma buffers on page boundaries returned by _DMAMap
; (so you can just allocate a buffer using _DMAMap
;  without having to check is the various pages are "in sequence"
;  and you also don't have to check if the data block
;  "is between" a dma page block)

extrn _DMAReceive:dword
; Receives data FROM a device using DMA
; EAX = channel, EBX = Physical mem ptr, ECX = Lenght in BYTES
; n.b.if you send/receive on a 16bit channel (4..7) remember to keep
;     address and byte count WORD ALIGNED
; n.b./2 better if you use the pages allocated and mapped by a scatterlist
;        (you will probably fuck eveything up if you don't)

extrn _DMAMap:dword
; Allocates & initializes a VDMA ScatterList into low memory
; IN: EAX= Size of buffer
; OUT: if Carry Clear then
;         EAX = Ptr to Scatterlist, _LoMemBase Updated
;      else EAX= pointer to error string for 386Return

extrn _DMAUnMap:dword
; Frees a VDMA ScatterList  (but does not deallocate memory from low heap)
; do this when terminating your program.
; IN: EAX= ScatterList to unlock
;

; Receives data FROM a device using DMA
; EAX = channel, EBX = Physical mem ptr, ECX = Lenght in BYTES
; n.b.if you send/receive on a 16bit channel (4..7) remember to keep
;     address and byte count WORD ALIGNED
; Remember that using the scatterlist you have to send data in chunks
; of up to 4k bytes (not a big problem to me, if you use dma to send
; voice data you HAVE to scatter it to perform software mixing)

; ScatterList structure (returned by a call to _DMAMap )
VDMA_PTR   = 0  ; dd code32 relative pointer
VDMA_SIZE  = 4  ; dd size
VDMA_OFS   = 8  ; dd offset (the current version uses low memory)
VDMA_SEG   = 12 ; dw real mode offset (the current version uses low mem)
VDMA_PAGES = 16 ; pages requested
VDMA_USED  = 18 ; pages actually allocated  (use this to determine
                ; how many (code32,physical) address couples
                ; are present starting from VDMA_SCATS
VDMA_SCATS = 20 ; start of "couples" of scattered page entries
; where the VDS server puts only page entries
; the VDMA system will put COUPLES of dwords
; (the first dword is the code32 relative
; offset of the page,the 2nd dword is the physical address you have to send
; to the dma hardware
; so at offset VDMA_SCATS    you find the code32 address of the first page
;          at  VDMA_SCATS+4  you find the equivalent PHYSICAL address
; and so on ...


; do not performs "smart" jump optimizations automatically
; (this is needed to avoid code size screw-ups)
NOJUMPS

; do not perform automatic "smart" optimization, so nothint harmful
; will happen to some critical code sequences
NOSMART
