:h1. March 20 Release
:p.

An enormous number of features have been added in the last four
days.  Forms support is nearly complete.  A lot of testing found
a number of small bugs in the forms code.  A scheme to integrate
SpHyDir forms and the IBM GOSERVE package as been created.
:UL.
:li. 
SpHyDir creates all the HTML 2.0 forms objects (excluding ISMAP,
which is technically not a part of Forms).
:li. 
SpHyDir "compiles" into the external attributes of the file a
symbol table of Forms variables and the location in the file
where the corresponding character string is located.
:li. 
The SpHyDir_Extract helper routine can be used by a Rexx
processing program running under the GOSERVE Web Server
environment to extract the parameters of a Forms request and
turn them into native Rexx variables.
:li. 
The SpHyDir_Reply help routine, running in the same environment,
takes the name of a SpHyDir generated HTML file, copies it into
a temporary dataset inserting the current values of Rexx
variables (if they exist) for each correspondingly named Forms
variable defined in the HTML file.
:eUL.
:p.

Minor changes, often requested by users&colon.
:UL.
:li. 
SpHyDir now allows the Definition Term <DT> to be a hypertext
link to some other document.  This was patched in, so there is a
restriction that if an <A HREF=> appears anywhere in the term,
the entire term is treated as the hyperlink and, therefore, you
cannot have two links from different words in the term.
:li. 
HREF=filename is now rather rigourously folded to lowercase to
simplify the process of porting scripts to Unix servers.  Again,
I tried to sweep up all the loose ends, and if you can find any
I missed I will be quite interested in examples of any filenames
that still come out in uppercase.
:li. 
IPF files can get to be an annoyance if you don't want them. 
SpHyDir now will not build an IPF file unless something with
that name already exists.  If you have a file named, say,
SOME.HTM and you want an IPF file created, then just
.br
[c&colon.]copy some.htm some.ipf
.br
Then the next time SpHyDir processes SOME.HTM it will notice
that the IPF file is present and will replace it with the
corresponding IPF source.  This seemed like the simplest way to
handle the choice.
:li. 
The Icons are now all bound to the EXE as resources and are
referenced as such.  Therefore, SpHyDir no longer requires that
the current directory have all the *.ICO files and they are no
longer distributed in the ZIP file.  If you wish, you can get
rid of them in your directory as well.
:eUL.
:h1. March 16 Release
:p.

In a FORM, the HTML PASSWORD entry field is now supported. A
Password attribute can be assigned to the previous ENTRY field
object.
:p.

The toolbar has a Pushbutton object. With no parameters, a
Pushbutton is named SUBMIT and tranmits the form data. A
Pushbutton can also be assigned a variable name and value that
will be transmitted with the rest of the form data. The value
sets the caption on the button.
:p.

HTML supports a HIDDEN object that contains data (a userid,
transaction ID, or other handle). It is sent to the browser but
is not displayed on the screen. It is added to any forms input.
This allows the server programs to carry information from one
transaction to the next. To support this without adding a new
tool to the toolbar, SpHyDir has added a "hidden" attribute to
the Pushbutton object.
:p.

A new Extended Attribute named "Variables" has now been added to
each HTML file with FORMS. This EA identifies the location of
any data in the HTML file that is associated with a variable
name associated with a FORMS object. For example, if a Text
Entry Field is associated with the variable name PHONENUM, there
will be an entry in the Variables EA indicating the type of
field (ENTRY), the variable name (PHONENUM), and the location in
the HTML file where a previous phone number value might be
inserted. The field would be generated as&colon.
.br
<INPUT TYPE="TEXT" NAME="PHONENUM" VALUE="">
.br
and the EA would have the byte offset in the file of the first
double quote following VALUE.
:p.

This form is perfectly valid as a static HTML file. Transmitted
as is, the phone number field would appear empty. However, if
the form is sent out from the server by a forms processing
program that uses SpHyDir "helper routines", and if the PHONENUM
variable is also defined in the sending program, then the
current value of the variable will be inserted into the field.
For example, if a Rexx program had
.br
PHONENUM="203-555-1234" and sent the form out with a helper
program, then the resulting HTML after the insertion would
be&colon.
.br
<INPUT TYPE="TEXT" NAME="PHONENUM" VALUE="203-555-1234">
:p.

Rexx is a particularly nice language for this purpose because
the user program doesn't have to specially identify the
variables used in the Form. The helper routine can query the EA,
then check the Rexx symbol table for each variable name found in
the form to see if there is an existing Rexx variable of the
same name. To play the same trick with other langauges, such as
C, the processing program first has to pass the variable and
name to the interface routine as in&colon.
.br
SpHyDir_define("PHONENUM",&amp.phonenum);
:p.

The content of a FORM structure will not be generated in the IPF
file. IPF files also do not receive normal text (annotations)
after the first Subdocument has been processed. In HTML, a
subdocument is a Link to another file. In IPF a subdocument
imbeds the other file at the point where the subdocument
appears, so it is unnecessary and impossible to describe after
that point what the subdocument contains.
:p.

IPF output is now completely supressed within a FORM. Ordinary
text objects are also now supressed in the IPF file after the
first SUBDOC has been processed. This was necessary to allow
Subdocument links to be commented in HTML (where the links jump
to separate files) but to have those comments omitted in IPF
(where subdocuments are logically imbedded at the point of the
reference). Look at the handling of Subdocuments on then Entry
page of the SpHyDir documentation for an example.
:h1. March 14 Release
:p.

SpHyDir now generates HEIGHT and WIDTH tags for Image objects.
Netscape supports them and is much faster when they are present.
HTML 3.0 also includes them in the standard. Other browsers will
ignore them. SpHyDir ignores these attributes when reading HTML
in, but when it goes to generate the IMG tag it opens the GIF
file and reads the image size from the header. If the size of an
image changes, the HTML can be updated by reading and rewriting
any pages that reference the image.
:p.

In a related area, the Document Tree window (introduced two days
ago) now has a File menu with a Generate Tree item. Selecting
this item will regenerate the root document and all of the
subdocuments of the current multi-file tree. This makes it
simple to change boilerplate (Header and Trailer line) globally
or add new features (like adding HEIGHT and WIDTH fields to all
graphics.
:p.

A user requested keyboard shortcuts for character emphasis. With
the Text Edit window, select a section of text and use&colon.
.br
Ctrl-B for Bold
.br
Ctrl-I for Italics
.br
Ctrl-E for EM
.br
Ctrl-C for Cite
.br
Ctrl-S for Strong
:p.

Size fields were omitted from Forms object editing. This
provided no way to control the height and width of Multiline
Entry objects or the height of a LISTBOX. A pair of fields has
been added to the entry area section of the main window.
:p.

Some mistakes were made in the first cut at Forms. The most
serious problem was with SELECT lists (as in a LISTBOX). It was
originally designed to return a number indicating the index of
the selected item. This is a good idea if the alternatives in
the box are static. However, in current HTML and HTTP use, the
set of items in the list could be generated by one program,
inserted into the form, and then returned to a second program.
When the list contents are dynamic, there is no good way to map
an index number to any particular alternative. So the index
numbers are dropped, and a LISTBOX or SPIN now returns the
character string displayed to the user as the text of the list
alternative.
:p.

The Submit (and Reset) pushbuttons will soon appear on the
Toolbar. At that point, Submit buttons read in will be turned
into objects and will be generated back out. The Forms object
will stop generating the Submit button automatically.
:h1. March 12 Release
:p.

The arrival of a test version of Netscape 1.1 must focus
attention on the discussion about HTML 3.0. Given that the 2.0
standard is still being developed, it will be a long time before
the 3.0 standard is approved. However, Netscape is the most
widely used browser (according to the NY Times) and the fact
that it already supports many proposed 3.0 features is going to
force the issue. If SpHyDir is shortly going to have to add
support for more complex objects such as Figures and Tables,
then it is necessary now to "leave room" for those extensions.
:p.

The only direct effect of HTML 3.0 on this release is the
automtic generation of LINK statements in the HEAD section for
Parent, Next, and Previous. That information was already being
stored as Extended Attributes, but there was previously no
established LINK syntax for these relations.
:p.

A secondary effect of the standard was to finally address the
Target bug. An examination of the HTML source for the document
defining the standard showed that it was valid to have an <A
NAME=...> tag with no ending </A>. The standard document was
full of these constructions. That is a great syntax for the
Target construct, except that SpHyDir would previously have
regarded this as invalid HTML. The parse was changed to allow
this, and to detect conditions where in previous releases an
unclosed <H2> or similar tag would cause a crash.
:p.

The Document Tree window is now built. It is one of the options
in the Window pulldown list. Starting at the document currently
in the Workarea, it walks up Parent pointers till it reaches the
root file for the current compound document, then walks back
down the tree following subdocument pointers to build a
cumulative Table of Contents for all of the headers in all of
the subdocuments in the tree. Right now this is just nice to
look at. In the longer term, it will be used for several
things&colon.
:UL.
:li. 
This will become the source of the Table of Contents subdocument
that will be automatically generated for the tree. There will be
an option to insert a pointer to the TOC from the header and
trailer of each document in the tree (or to have it generated
automatically by an HTML 3.0 browser from a LINK relationship).
From the TOC the reader will then be able to jump to any header
in any subdocument in the tree.
:li. 
The currently unused Res field will become the place to track
Resource numbers. A unique resource ID must be assigned to every
header in order for the IPF files to be compiled as a HLP
instead of just as an INF file. This would then allow the
various SpHyDir fields and buttons to be connected to panels in
the regular OS/2 help system. A resource number is just an
arbitrary 16-bit integer, but once is is assigned to a heading
it should not be changed, because the number may have been coded
into an application at that point. SpHyDir has to automatically
assign a resource number to each header in the tree that doesn't
have one, but then it must assign a new number unique across the
entire tree to every new header that is subsequently added to
any document. If a header moves by drag and drop or by the
clipboard, the resource number has to move with it. Since the
numbers will not remain consecutive, the Document Tree window
will provide a means of tracking them.
:li. 
The Document Tree should provide a good source for generating
internal links and references of the form, "This subject has
already been covered in the section on 'Planning for
Installation'" where the citation would become an active link to
the named heading.
:eUL.
:p.

The HTML 3.0 standard finally provides a workably complete
discussion about what is and is not valid within a <PRE> tag.
SpHyDir support for preformatted text was rewritten to conform
more closely to the standard. In particular, it should now be
possible to generate hypertext links out of preformatted text.
:p.

One problem, however, is that HTML 3.0 adds a large number of
new attributes to existing tags. Nothing has been done about
this at the moment, but it will force reconsideration of the
general handling of the "entry areas" at the top of the
workarea.
:h1. March 5 Release
:p.

The unexpectedly long development of FORM support has now
reached the point where a new version of the code can be posted.
Since the toolbar was substantially changed, the documentation
needed to be updated. This version should fix most of the
previously reported bugs.
:p.

The current version can read, edit, and generate most elements
of HTML FORMs. A few items were compromised to put together
something that was usable and testable. For example, the Submit
button is automatically generated at the end of the form and is
not under user control. There just wasn't room on the toolbar
for anything as marginally useful as the Submit button. However,
a keyboard generated object (like the current HR support) seems
reasonable.
:p.

Since Forms is not an IPF construct, it is the intent of the
design to generate no IPF output within a Form Object. However,
it was not possible to go back and enforce this rule when normal
document objects appear in a form. This will be corrected
shortly.
:p.

A few parameters cannot be edited. For example, you can't change
the size of a Multiline Entry field or a List Box. It just
wasn't possible to get that in and reorganize all the
documentation by Sunday night.
:h2. Forms Direction
:p.

More importantly, Forms support by itself isn't useful without a
framework to generate the programs called when the user submits
the form. Furthermore, programs that generate a form need to be
able to work off an HTML template, but insert variable data into
the template before it is shipped out. This appears to be very
feasible if SpHyDir is augmented by a GOFILTER.80 file for IBM's
GOSERVE 2.0.
:p.

Back in the days of OS/2 1.2, IBM had a product called "Dialog
Manager." It was based on SGML, just like HTML is today. It
worked particuarly well with Rexx. A user would define a Form,
and associate variables with data fields. An Entry Field would
be given the variable name "LastName". A Rexx program would make
a call to display the form on the screen. Internally, Dialog
Manager would search the Rexx symbol table for any variable
named "LastName" and, if one was found, its value would be
inserted as the contents of the form entry area. Furthermore,
after the user finished with the form, the values of each field
on the form would be automatically converted to Rexx variables
before control returned to the program.
:p.

That is the target of SpHyDir development over the next few
weeks. The exact design is not yet clear. The current forms
support is only the start.
:p.

A minor problem is to rework the supplied GOFILTER.80 program so
that it can map a METHOD=POST query name into the name of an
external Rexx function file. Then there has to be some seed-code
for an external function that reads in the query, parses the
variable names and values from the POST and converts them to
local variable names. The user then supplies logic specific to
the particular query, putting the information in ordinary Rexx
variables. Then the user logic calls a routine passing the name
of a SpHyDir-generated reply document/form.
:p.

Currently, SpHyDir uses OS/2 Extended Attributes to hold useful
information externally from the HTML text. For example, an EA
holds the document Title which can then be used when the file is
added as a subdocument of another file. EA's also are used to
describe the entire document tree structure and generate the
Next, Previous, Up links in the Header or Trailer code.
:p.

The idea is to generate a new set of Extended Attributes to
locate the insertion points for data and to associate those
points with variable names. When the HTML file is processed by
an ordinary GET request, then just the static text would be
transmitted. However, a Rexx program running within the GoServe
filter environment could call a subroutine that SpHyDir supplies
passing the name of an HTML file that SpHyDir had previously
compiled. This subroutine could locate the Extended Attributes,
find the Variable names associated with each field, query the
Rexx symbol table for correspondingly named Rexx variables, and
use the EA pointers to insert current Rexx variable values into
the HTML before shipping it out.
:p.

The Forms programming done on other systems in other languages
provides two bad alternatives. One type of program reads the
HTML as it is being shipped out, and substitutes information
when particular language constructions are encountered. This is
expensive and slows down the server. Another strategy calls a
program that has to generate all the HTML from within the
program. This produces programs that are almost entirely
"printf" with massively long strings. Such programs will
frequently generate bad HTML.
:p.

SpHyDir already has to tools to easily generate good HTML. By
"compiling" the insertion points for the file, and then storing
them externally in EA's, server processing can be performed
quickly and program logic can be simplified.
:h2. Other Changes
:p.

Under some pressure, I have begun to rebuild the File Menu. I
will still hold tight and resist any Open option, but the
current Generate may be joined by other options like New (to
clear), and so on.
:p.

The Window menu item is now the primary tool to display
secondary windows such as the Link Manager and Table of
Contents. The TOC tool was retired from the Toolbar. After some
experience with SpHyDir, it is clear that the TOC has to be a
file by itself and not an object in some other document.
:p.

The Image Alignment radio buttons have been replaced with a Spin
field. There just wasn't enough room for the buttons, and a Spin
field will allow additional values if any prove useful.
:p.

Some internal cleanup produced a few visible changes. The entry
areas at the top of the Workarea now change variable values when
you are done with them and not after every keystroke.
:p.

The Hint Text option has been more agressively used. The bottom
"status" line of the Workarea window should show the meaning of
each entry field.
:h2. Smaller Issues
:p.

Work on the Table of Contents was suspended to add Forms
support. In its simplest version, the TOC is an automatically
generated document built from the entire document tree (the root
document and all its subdocuments). The TOC contains the header
text from all Section Objects and an HREF to the file and
location of the header itself. Targets have always been an
unresolved issue, and the TOC was to provide the framework for
addressing it. Unfortunately, IPF added some complications
because links to header in a HLP file are based on a numeric
resource id instead of a name. I feel that I am close to
figuring out how to do this, but the final big picture has not
yet become clear.
:p.

The File and Window menus need shortcut keys (like F2, etc.).
