:h1. Supported and Unsupported HTML
:p.

SpHyDir explicitly supports the HTML, HEAD, and BODY document
structure tags. SpHyDir reads, remembers, and recreates the
TITLE. SpHyDir will generate LINK tags that reflect
relationships between documents in the tree. Except for TITLE,
all information in other HEAD tags (ISINDEX, NEXTID, LINK, BASE,
META) would be lost.
:p.

SpHyDir supports H1...H6 when they are really used as the
heading of a section and not just to get big characters.
:p.

SpHyDir will normally generate paragraphs within a formal pair
of <P> and </P> tags. Since many existing documents do not
contain ending </P> tags, SpHyDir does not expect or require
them.
:p.

UL, OL, and DL lists are supported along with LI, DT, and DD
elements. Nested lists are fine. It is not entirely clear just
what other structural elements are reasonable inside lists. A
lot of NCSA documents seem to mix in ordinary paragraphs along
with the expected LI tags. Currently, SpHyDir lets you put lots
of stuff in a list, but it will absolutely refuse to generate a
document if it finds a Section nested inside any List
alternative.
:p.

The Horizontal Rule <HR> tag is supported. There is no icon or
tool for it. This is not because it is hard to come up with an
icon for a horizontal line. About ten seconds with the icon
editor will produce it. To add an HR tag to a document, select
the object you want it to proceed in the workarea and press
Alt-H.
:p.

The PRE tag is recognized. The WIDTH attribute is not scanned
and will not be regenerated. Preformatted text is similar to
ordinary paragraphs, except that line breaks and multiple
embedded spaces are preserved.
:p.

Hypertext labels pose a problem for SpHyDir and for HTML and
IPF. First, HTML is changing the syntax. The current approach <A
NAME=xxx> assigns a label to a string. The HTML 3.0 standard
changes NAME to ID and allows the "ID=name" attribute to occur
inside the H1..H6 and P tags as well as in an A tag. IPF only
allows headings to be the target of a jump, and in a HLP file
the ID has to be a number (the Resource ID). SpHyDir has decided
to split the difference. When a current HTML <A NAME=xxx> tag is
encountered, it is used to construct a Target object. However,
the Target is moved to the front of the current Paragraph or
section. It is then generated as an <A NAME=xxx> prefix to the
<P> or <Hn> tag (a construct supported by current HTML 2.0
browsers). Later on, when HTML 3.0 is established, the label can
migrate inside the P or Hn tag as the new ID attribute.
Meanwhile, the IPF Resources are handled outside of HTML syntax
because they are not a part of HTML.
:p.

A Hypertext link is created from any <A HREF=...> tag
encountered. SpHyDir requires that the filename or URL not
contain any blanks. Other attributes (REL, REV, TITLE) are
ignored.
:p.

The IMG tag may have SRC, ALIGN, and ALT attributes. Currently,
only the LEFT Netscape extended alignment is supported, and that
is just a test. An IMG file must have a type of GIF for HTML and
BMP for IPF. The free IBM utility GBM can be used to convert GIF
to BMP.
:p.

ADDRESS is not explicitly supported. When encountered, it is
currently embedded in the text of a paragraph as if it were
character emphasis. When SpHyDir generates HTML, it includes
boilerplate from the HEADER and TRAILER files, and that will
generally be the source of the author's name, E-mail, etc. The
ADDRESS tag would typically be used in these files and not in
the body of the text.
:p.

The &amp.amp, &amp.lt, and &amp.gt entities are converted to
ordinary characters on input and are regenerated on output.
Currently no other entities are supported. It is the direction
of SpHyDir to find a way to support direct editing of ISO 8859-1
characters rather than requiring them to be edited. SpHyDir uses
some PC-only graphic characters as delimiters for hypertext
links and character emphasis.
:p.

Forms support is under development. The following information
about forms is tentative (as of March 1) and represents work in
progress.
:p.

The FORM and /FORM tags generate a section of the document
represented by the FORM object. Only the more generate POST
method will be supported (using GET with forms is sometimes
possible, but there are length restrictions that appear to be
more trouble than they are worth). The ACTION can be the name of
a CGI program for a Unix server, or a name that GOSERVE will
recognize as a supported operation on OS/2.
:p.

At the moment, there is a shortage of room on the toolbar, the
SUBMIT and RESET buttons are ignored on input and are generated
automatically on output at the end of the FORM.
:p.

Within the FORM area, one can include any other document
objects, including Sections, Images, Lists, and links. There is
one change to SpHyDir document management. All the previously
discussed document objects operate at the level of a Paragraph
or larger. Form objects have an integrity of their own, but
several check boxes or radio buttons can appear together on the
same line. To accomodate this behavior, SpHyDir allows empty
paragraphs to exist within a FORM.
:p.

A user has always been able to generate an empty paragraph
(<P></P>) by dragging a paragraph object to the workarea but
then adding no text to it. However, empty paragraphs read in
during the HTML scan would be ignored. Essentially, the empty
paragraph was treated as a user error that SpHyDir might choose
to ignore. However, it turns out that there is no more
acceptable way to delimit line breaks in a form. During the HTML
scan of an externally generated FORM, SpHyDir will create empty
paragraph elements when <P> tags are encountered between form
elements, and it will then generate them as&colon.
.br
<P></P>
.br
<INPUT TYPE="RADIO" NAME="PROT" VALUE="HTTP"> HTTP
.br
<INPUT TYPE="RADIO" NAME="PROT" VALUE="GOPHER"> Gopher
.br
<INPUT TYPE="RADIO" NAME="PROT" VALUE="FTP"> FTP
.br
<P></P>
.br
<INPUT TYPE="CHECKBOX" NAME="BIN"> BINARY
.br
<P></P>
.br
In this example, the three radio buttons will appear on one
line, and the checkbox will appear on a separate line following
them. Graphically, each line of this HTML appears in SpHyDir as
an object, with three empty Paragraph objects, three RadioButton
objects, and one CheckBox object in the order given above.
:p.

Now we get to one of those wild generalizations on which the
whole concept of SpHyDir depends. Forms items have captions. You
know that, and I know that, but HTML doesn't know it. In HTML, a
check box is just the box&colon.
.br
<INPUT TYPE="CHECKBOX" NAME="BIN"> BINARY
.br
Syntatically, the last word "BINARY" is outsize the tag. It is
just text. If SpHyDir didn't make any stuctural assumptions, it
would just appear as ordinary paragraph text. Now we want it to
have all the freedom of text (so you edit it with the Text
Editor Window, and you can link to it by dropping Link Manager
links on it, and it opens the Hotword Window). But, the document
view becomes terribly fragmented if this line generates two
objects (a CheckBox object for the tag, and a Paragraph object
for the caption).
:p.

So SpHyDir makes the unsupported generalization that the caption
for an Entry Field goes in front of the field, and the caption
for a CheckBox or RadioButton goes after the button. Multiline
text input areas and Selection Lists don't have a caption (or if
they do, it appears as a paragraph above or below the larger
areas). Thus Entry, CheckBox, and RadioButton objects have a
text component that appears in the SpHyDir work area like
paragraph text to the right of the object. The text of the
caption can be edited or linked exactly as if it were in a
Paragraph object. When the HTML is generated, however, the Entry
object text goes in front of the <INPUT> tag, and the CheckBox
and RadiButton text goes after it.
