/*           ircII for OS/2 Starup file. Requires REXX.
               Copyright (c)1995 by danp@busstop.org

  This REXX script will read the required values from IRCII.INI (created by
  IRCINST.EXE) and then load ircII for OS/2.

*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs

/* This finds the ircII for OS/2 IRCII.INI file to read from. If none can be
   found, the IRCINST.EXE program is executed. */

  irc_inifile=SysSearchPath('PATH','ircii.ini')   
  if irc_inifile = '' then irc_inifile=SysSearchPath('DPATH','ircii.ini')

 if irc_inifile <> '' then do 
   rc = SysFileSearch('DEVICE',irc_inifile,'file')
   if rc = 3 then call 'ircinst'
 end
 else call 'ircinst'

  irc_inifile=SysSearchPath('PATH','ircii.ini')   
  if irc_inifile = '' then irc_inifile=SysSearchPath('DPATH','ircii.ini') then
     ircIIDrive = SysIni(irc_inifile,'ircII','ircIIDrive')
     ircIIDir   = SysIni(irc_inifile,'ircII','ircIIDir')
     ircIIPath  = SysIni(irc_inifile,'ircII','ircIIPath')
     ircIIrc    = SysIni(irc_inifile,'ircII','ircIIrc')
     IRCNick    = SysIni(irc_inifile,'ircII','IRCNick')
     UserName   = SysIni(irc_inifile,'ircII','UserName')
     RealName   = SysIni(irc_inifile,'ircII','RealName')
     IRCServer  = SysIni(irc_inifile,'ircII','IRCServer')

/* Set up HOME, IRCLIB, IRCRC, (TERMCAP), and (TERM) stuff */
    ircrc=ircIIrc
    LibDir=IrcIIPath
    ircIIHome = STRIP(ircIIPath,"Trailing") 
    ircIIHome = STRIP(ircIIPath,"Trailing","\")
    HomeDir = ircIIHome

/* Get stuff from the environment if they're there... */

If Value('TERMCAP',,'OS2ENVIRONMENT') <> '' Then,
   Termcap = Value('TERMCAP',,'OS2ENVIRONMENT')
else Call Value 'TERMCAP','<place path here>','OS2ENVIRONMENT'

If Value('TERM',,'OS2ENVIRONMENT') <> '' Then,
   Term = Value('TERM',,'OS2ENVIRONMENT')
else Call Value 'TERM','rmono','OS2ENVIRONMENT'

/*  Load Values into the environment */

Call Value 'TERMCAP',Termcap,'OS2ENVIRONMENT'
Call Value 'TERM',Term,'OS2ENVIRONMENT'
Call Value 'HOME',HomeDir,'OS2ENVIRONMENT'
Call Value 'IRCLIB',LibDir,'OS2ENVIRONMENT'
Call Value 'IRCRC',ircrc,'OS2ENVIRONMENT'
Call Value 'USER',UserName,'OS2ENVIRONMENT'
Call Value 'IRCNICK',IRCNick,'OS2ENVIRONMENT'
Call Value 'IRCNAME',RealName,'OS2ENVIRONMENT'
Call Value 'IRCSERVER',IRCServer,'OS2ENVIRONMENT'

/* REXX stuff for DCC's or something */

'@hostname | rxqueue'
Parse pull hostname .
Call Value 'HOSTNAME',hostname,'OS2ENVIRONMENT'

/* Set the Screen Mode */

'@mode CO80,30'

/* And Finally, load up ircII */
'@irc'
