/*****************************************************************************
 * v2.50 : Taskbar program uninstall
 *
 * (c)Copyright 1995 Rick Yoder
 *****************************************************************************/
SIGNAL ON SYNTAX

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

SAY "Uninstalling Taskbar for OS/2 ..."
CALL DeleteObjects
EXIT

/*****************************************************************************
 * DeleteObjects    - procedure to delete existing Workplace Shell objects.
 *                    Terminates the install script if an error occurs.
 *****************************************************************************/
DeleteObjects: PROCEDURE

    CALL DeleteOldPgmObjects        /* destroy objects created by old versions */
    CALL DeregisterClass            /* deregister 'Taskbar' class if it exists */

    RETURN
/*****************************************************************************/

/*****************************************************************************
 * DeleteOldPgmObjects    - deletes objects created by prior versions
 *                          of Taskbar. Terminates the install script if
 *                          an error occurs.
 *****************************************************************************/
DeleteOldPgmObjects: PROCEDURE

    /* Destroy the old shadow object if it exists */
    result = SysIni( 'USER','PM_Workplace:Location','<Taskbar_RFY_Shadow>' )
    IF result \= 'ERROR:' THEN
        DO
            IF 0 = SysDestroyObject('<Taskbar_RFY_Shadow>') THEN
                DO
                    SAY 'Error destroying old shadow object.'
                    EXIT
                END
        END

    /* Destroy the old program object if it exists */
    result = SysIni( 'USER','PM_Workplace:Location','<Taskbar_RFY>' )
    IF result \= 'ERROR:' THEN
        DO
            IF 0 = SysDestroyObject('<Taskbar_RFY>') THEN
                DO
                    SAY 'Error destroying old program object.'
                    EXIT
                END
        END

    /* Destroy beta objects */
    result = SysIni( 'USER','PM_Workplace:Location','<TASKBAR_BETA>' )
    IF result \= 'ERROR:' THEN
        DO
            IF 0 = SysDestroyObject('<TASKBAR_BETA>') THEN
                DO
                    SAY 'Error destroying beta test object.'
                    EXIT
                END
        END

    RETURN
/*****************************************************************************/

/*****************************************************************************
 * DeregisterClass        - checks whether the Taskbar class is currently
 *                          registered with the Workplace Shell, and
 *                          deregisters it if it exists. Terminates the
 *                          install script if an error occurs.
 *****************************************************************************/
DeregisterClass: PROCEDURE

    CALL SysQueryClassList "list."
    DO i = 1 TO list.0
        PARSE VAR list.i ClassName DLLName
        IF ClassName = "Taskbar" THEN
            DO
                IF 0 = SysDeregisterObjectClass("Taskbar") THEN
                    DO
                        SAY "Error deregistering Taskbar object class."
                        EXIT
                    END
                RETURN
            END
    END

    RETURN
/*****************************************************************************/

/*****************************************************************************/
 * Standard REXX program error handlers
 *****************************************************************************/
SYNTAX:
    SAY 'REXX error' rc 'in line' sigl
    SAY "Instruction = "||SOURCELINE(sigl)
    EXIT
/*****************************************************************************/
